/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.dataEditor;

import dmLab.DMLabInfo;
import dmLab.array.Array;
import dmLab.array.SArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.fileLoader.FileType;
import dmLab.array.meta.Attribute;
import dmLab.gui.dataEditor.ContainerOperations;
import dmLab.gui.dataEditor.EditorInfo;
import dmLab.gui.dataEditor.components.EditorMenuBar;
import dmLab.gui.dataEditor.components.EditorToolBar;
import dmLab.gui.dataEditor.panels.AttrFilterPanel;
import dmLab.gui.dataEditor.panels.AttributesPanel;
import dmLab.gui.dataEditor.panels.DBConnectionPanel;
import dmLab.gui.dataEditor.panels.EventsFilterPanel;
import dmLab.gui.dataEditor.panels.EventsPanel;
import dmLab.gui.dataEditor.panels.OptionsPanel;
import dmLab.gui.dataEditor.panels.ReplacePanel;
import dmLab.gui.dataEditor.utils.InfoStream;
import dmLab.gui.dataEditor.windows.AboutWindow;
import dmLab.gui.dataEditor.windows.DBConnectionWindow;
import dmLab.utils.fileFilters.MyFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.table.TableModel;

public final class EditorBody
extends JFrame
implements ActionListener {
    private static String GUITitle = "dmLab - Data Editor";
    private EditorMenuBar editorMenuBar;
    private EditorToolBar toolBar;
    private JSplitPane horizontalSplitPanel;
    private JSplitPane verticalSplitPanel;
    private JTabbedPane tabbedPanel;
    private JScrollPane scrollInfoPanel;
    private JTextPane infoPanel;
    private OptionsPanel optionsPanel;
    private ReplacePanel replacePanel;
    private EventsFilterPanel filterPanel;
    private AttrFilterPanel attrFilterPanel;
    private AttributesPanel attributesPanel;
    private EventsPanel eventsPanel;
    private JProgressBar progressBar;
    private JFileChooser fileDialog;
    private InfoStream outStream;
    private InfoStream errStream;
    private ContainerOperations containerOperations;
    private AboutWindow aboutWindow;
    private DBConnectionWindow dbConnectionWindow;

    public static void run() {
        EditorBody editorBody = new EditorBody();
        editorBody.setVisible(true);
    }

    public EditorBody() {
        System.out.print(new DMLabInfo().toString());
        this.containerOperations = new ContainerOperations();
        this.progressBar = new JProgressBar();
        this.containerOperations.setProgressBar(this.progressBar);
        this.outStream = new InfoStream();
        this.errStream = new InfoStream();
        this.setDefaultCloseOperation(3);
        this.aboutWindow = new AboutWindow(new EditorInfo().toString());
        this.dbConnectionWindow = new DBConnectionWindow();
        Serializable serializable = this;
        JFrame jFrame = this.dbConnectionWindow;
        Container container = serializable;
        serializable = ((DBConnectionWindow)jFrame).dbConnectionPanel;
        ((DBConnectionPanel)serializable).runQueryButton.addActionListener((ActionListener)((Object)container));
        jFrame = this;
        try {
            jFrame.setTitle(GUITitle);
            serializable = jFrame;
            ((EditorBody)jFrame).editorMenuBar = new EditorMenuBar();
            Serializable serializable2 = serializable;
            container = ((EditorBody)serializable).editorMenuBar;
            ((EditorMenuBar)container).openDBMenuItem.addActionListener((ActionListener)((Object)serializable2));
            ((EditorMenuBar)container).openFileMenuItem.addActionListener((ActionListener)((Object)serializable2));
            ((EditorMenuBar)container).saveAsMenuItem.addActionListener((ActionListener)((Object)serializable2));
            ((EditorMenuBar)container).closeFileMenuItem.addActionListener((ActionListener)((Object)serializable2));
            ((EditorMenuBar)container).exitMenuItem.addActionListener((ActionListener)((Object)serializable2));
            ((EditorMenuBar)container).aboutMenuItem.addActionListener((ActionListener)((Object)serializable2));
            ((JFrame)serializable).setJMenuBar(((EditorBody)serializable).editorMenuBar);
            ((EditorBody)serializable).editorMenuBar.setPreferredSize(new Dimension(392, 18));
            jFrame.setSize(800, 600);
            jFrame.setLocation(100, 100);
            ((EditorBody)jFrame).horizontalSplitPanel = new JSplitPane();
            ((EditorBody)jFrame).verticalSplitPanel = new JSplitPane();
            ((EditorBody)jFrame).scrollInfoPanel = new JScrollPane();
            ((EditorBody)jFrame).infoPanel = new JTextPane();
            ((EditorBody)jFrame).progressBar = new JProgressBar();
            ((EditorBody)jFrame).tabbedPanel = new JTabbedPane();
            ((EditorBody)jFrame).optionsPanel = new OptionsPanel();
            ((EditorBody)jFrame).replacePanel = new ReplacePanel();
            ((EditorBody)jFrame).attributesPanel = new AttributesPanel();
            ((EditorBody)jFrame).filterPanel = new EventsFilterPanel();
            ((EditorBody)jFrame).attrFilterPanel = new AttrFilterPanel();
            ((EditorBody)jFrame).eventsPanel = new EventsPanel();
            ((EditorBody)jFrame).toolBar = new EditorToolBar();
            container = jFrame;
            serializable = ((EditorBody)jFrame).toolBar;
            ((EditorToolBar)serializable).dbButton.addActionListener((ActionListener)((Object)container));
            ((EditorToolBar)serializable).reloadButton.addActionListener((ActionListener)((Object)container));
            ((EditorToolBar)serializable).fixTypesButton.addActionListener((ActionListener)((Object)container));
            ((EditorToolBar)serializable).saveButton.addActionListener((ActionListener)((Object)container));
            ((EditorToolBar)serializable).openButton.addActionListener((ActionListener)((Object)container));
            jFrame.getContentPane().add((Component)((EditorBody)jFrame).toolBar, "North");
            jFrame.getContentPane().add((Component)((EditorBody)jFrame).horizontalSplitPanel, "Center");
            jFrame.getContentPane().add((Component)((EditorBody)jFrame).progressBar, "South");
            ((EditorBody)jFrame).horizontalSplitPanel.setOrientation(0);
            ((EditorBody)jFrame).horizontalSplitPanel.add((Component)((EditorBody)jFrame).verticalSplitPanel, "top");
            ((EditorBody)jFrame).horizontalSplitPanel.add((Component)((EditorBody)jFrame).eventsPanel, "bottom");
            ((EditorBody)jFrame).tabbedPanel.addTab("Info", null, ((EditorBody)jFrame).scrollInfoPanel, null);
            ((EditorBody)jFrame).tabbedPanel.addTab("Options", null, ((EditorBody)jFrame).optionsPanel, null);
            ((EditorBody)jFrame).tabbedPanel.addTab("Replace", null, ((EditorBody)jFrame).replacePanel, null);
            ((EditorBody)jFrame).tabbedPanel.addTab("Filter Events", null, ((EditorBody)jFrame).filterPanel, null);
            ((EditorBody)jFrame).tabbedPanel.addTab("Filter Attrs", null, ((EditorBody)jFrame).attrFilterPanel, null);
            container = jFrame;
            serializable = ((EditorBody)jFrame).replacePanel;
            ((ReplacePanel)serializable).replaceButton.addActionListener((ActionListener)((Object)container));
            container = jFrame;
            serializable = ((EditorBody)jFrame).filterPanel;
            ((EventsFilterPanel)serializable).filterButton.addActionListener((ActionListener)((Object)container));
            container = jFrame;
            serializable = ((EditorBody)jFrame).attrFilterPanel;
            ((AttrFilterPanel)serializable).filterButton.addActionListener((ActionListener)((Object)container));
            ((EditorBody)jFrame).infoPanel.setText("Please Load the Data.\n");
            ((EditorBody)jFrame).scrollInfoPanel.setViewportView(((EditorBody)jFrame).infoPanel);
            container = jFrame;
            serializable = ((EditorBody)jFrame).attributesPanel;
            ((AttributesPanel)serializable).decisionSetButton.addActionListener((ActionListener)((Object)container));
            ((AttributesPanel)serializable).addNewAttributeButton.addActionListener((ActionListener)((Object)container));
            ((AttributesPanel)serializable).removeAttributeButton.addActionListener((ActionListener)((Object)container));
            ((EditorBody)jFrame).attributesPanel.setPreferredSize(new Dimension(400, 400));
            ((EditorBody)jFrame).attributesPanel.setPointers(((EditorBody)jFrame).containerOperations, ((EditorBody)jFrame).eventsPanel);
            ((EditorBody)jFrame).verticalSplitPanel.add((Component)((EditorBody)jFrame).attributesPanel, "left");
            ((EditorBody)jFrame).verticalSplitPanel.add((Component)((EditorBody)jFrame).tabbedPanel, "right");
            ((EditorBody)jFrame).verticalSplitPanel.setPreferredSize(new Dimension(800, 400));
            ((EditorBody)jFrame).outStream.setOutput(((EditorBody)jFrame).infoPanel, InfoStream.OUT);
            ((EditorBody)jFrame).errStream.setOutput(((EditorBody)jFrame).infoPanel, InfoStream.ERR);
            ((EditorBody)jFrame).eventsPanel.setPointers(((EditorBody)jFrame).containerOperations, ((EditorBody)jFrame).attributesPanel, ((EditorBody)jFrame).optionsPanel);
            ((EditorBody)jFrame).eventsPanel.fillEventsTable();
            serializable = jFrame;
            ((EditorBody)serializable).progressBar.setValue(0);
            ((EditorBody)serializable).progressBar.setForeground(new Color(200, 0, 0));
            ((EditorBody)serializable).progressBar.setStringPainted(true);
            return;
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void initFileDialog() {
        this.fileDialog = new JFileChooser("D://JAVA Source//dmLAB//");
        this.fileDialog.setLocation(100, 100);
        MyFileFilter[] fileFilters = FileType.getSupportedTypes();
        int i = 0;
        while (i < fileFilters.length) {
            this.fileDialog.addChoosableFileFilter(fileFilters[i]);
            ++i;
        }
        this.fileDialog.addChoosableFileFilter(new MyFileFilter("", "All Supported Files"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void actionPerformed(ActionEvent event) {
        Object eventObject = event.getSource();
        if (eventObject == this.editorMenuBar.openFileMenuItem || eventObject == this.toolBar.openButton) {
            eventObject = this;
            int n = ((EditorBody)eventObject).fileDialog.showOpenDialog((Component)eventObject);
            if (n != 0) return;
            File file = ((EditorBody)eventObject).fileDialog.getSelectedFile();
            System.out.println("Opening: " + file.getName() + ".");
            OptionsPanel optionsPanel = ((EditorBody)eventObject).optionsPanel;
            if (optionsPanel.separatorTab.isSelected()) {
                ((EditorBody)eventObject).containerOperations.setSeparatorCSV('\t');
            } else {
                ((EditorBody)eventObject).containerOperations.setSeparatorCSV(((EditorBody)eventObject).optionsPanel.getSeparatorCSV());
            }
            ((EditorBody)eventObject).containerOperations.setFirstLineContainsAttributesCSV(((EditorBody)eventObject).optionsPanel.getFirstLineContainsAttributesCSV());
            ((EditorBody)eventObject).containerOperations.setDefaultAttributeNameCSV(((EditorBody)eventObject).optionsPanel.getDefaultAtributeNameCSV());
            ((EditorBody)eventObject).containerOperations.setTrimCommentsCSV(((EditorBody)eventObject).optionsPanel.getTrimCommentsCSV());
            optionsPanel = ((EditorBody)eventObject).optionsPanel;
            ((EditorBody)eventObject).containerOperations.setConsequentSeparatorsTreatAsOneCSV(optionsPanel.consequentSeparatorsTreatAsOne.isSelected());
            if (!((EditorBody)eventObject).containerOperations.loadFromFile(file.getAbsolutePath())) return;
            System.out.println("File loaded.");
            ((Frame)eventObject).setTitle(String.valueOf(GUITitle) + " - " + ((EditorBody)eventObject).containerOperations.getFileName());
            ((EditorBody)eventObject).containerOperations.findDomains();
            super.updateGUI();
            return;
        }
        if (eventObject == this.editorMenuBar.openDBMenuItem || eventObject == this.toolBar.dbButton) {
            if (this.dbConnectionWindow == null) {
                this.dbConnectionWindow = new DBConnectionWindow();
            }
            this.dbConnectionWindow.setVisible(true);
            return;
        }
        if (eventObject == this.editorMenuBar.saveAsMenuItem || eventObject == this.toolBar.saveButton) {
            String string;
            this.updateMemory();
            this.updateGUI();
            eventObject = this;
            int n = ((EditorBody)eventObject).fileDialog.showSaveDialog((Component)eventObject);
            Serializable serializable = ((EditorBody)eventObject).optionsPanel;
            char c = ((OptionsPanel)serializable).separatorTab.isSelected() ? (char)'\t' : (char)((EditorBody)eventObject).optionsPanel.getSeparatorCSV();
            if (n != 0) return;
            super.updateMemory();
            serializable = ((EditorBody)eventObject).fileDialog.getSelectedFile();
            System.out.println("Saving: " + ((File)serializable).getName() + ".");
            ((EditorBody)eventObject).containerOperations.setSeparatorCSV(c);
            String string2 = "." + ((MyFileFilter)((EditorBody)eventObject).fileDialog.getFileFilter()).getExt();
            if (string2.equalsIgnoreCase(".")) {
                string2 = "";
            }
            if (!((EditorBody)eventObject).containerOperations.saveToFile(string = String.valueOf(((File)serializable).getAbsolutePath()) + string2)) return;
            System.out.println("File is saved.");
            return;
        }
        if (eventObject == this.editorMenuBar.closeFileMenuItem) {
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            System.out.println("Closing: " + ((EditorBody)eventObject).containerOperations.getFileName() + ".");
            ((EditorBody)eventObject).containerOperations.initContainer();
            System.out.println("File is closed.");
            ((Frame)eventObject).setTitle(GUITitle);
            ((EditorBody)eventObject).replacePanel.setAttributes(null);
            ((EditorBody)eventObject).attributesPanel.setAttributes(null);
            ((EditorBody)eventObject).eventsPanel.fillEventsTable();
            ((EditorBody)eventObject).attrFilterPanel.init();
            return;
        }
        if (eventObject == this.editorMenuBar.exitMenuItem) {
            eventObject = this;
            ((Window)eventObject).dispose();
            return;
        }
        if (eventObject == this.editorMenuBar.aboutMenuItem) {
            if (this.aboutWindow == null) {
                this.aboutWindow = new AboutWindow(new EditorInfo().toString());
            }
            this.aboutWindow.setVisible(true);
            return;
        }
        if (eventObject == this.replacePanel.replaceButton) {
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            int n = ((EditorBody)eventObject).containerOperations.replaceValue(((EditorBody)eventObject).replacePanel.getSourceValue(), ((EditorBody)eventObject).replacePanel.getDestinationValue(), ((EditorBody)eventObject).replacePanel.getSelectionMask(), ((EditorBody)eventObject).replacePanel.getWholeWord());
            System.out.println(n + " values have been replaced.");
            ((EditorBody)eventObject).eventsPanel.fillEventsTable();
            super.updateGUI();
            return;
        }
        if (eventObject == this.attributesPanel.decisionSetButton) {
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            String string = ((EditorBody)eventObject).attributesPanel.getAnchorAttributeName();
            ((EditorBody)eventObject).attributesPanel.setDecisionAttribute(string);
            System.out.println("Attribute " + string + " is new Decision Attribute.");
            return;
        }
        if (eventObject == this.attributesPanel.addNewAttributeButton) {
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            DiscFunctions.addAttribute(((EditorBody)eventObject).containerOperations.container);
            super.updateGUI();
            return;
        }
        if (eventObject == this.attributesPanel.removeAttributeButton) {
            Array array;
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            if (((EditorBody)eventObject).containerOperations.container.colsNumber() <= 1) return;
            int n = ((EditorBody)eventObject).attributesPanel.getAnchorAttributeIndex();
            ContainerOperations containerOperations = ((EditorBody)eventObject).containerOperations;
            int n2 = n;
            Array array2 = ((EditorBody)eventObject).containerOperations.container;
            if (n2 < 0 || n2 > array2.colsNumber()) {
                array = null;
            } else {
                boolean[] blArray = new boolean[array2.colsNumber()];
                boolean[] blArray2 = new boolean[array2.rowsNumber()];
                Arrays.fill(blArray, true);
                Arrays.fill(blArray2, true);
                blArray[n2] = false;
                array = array2 = array2.clone(blArray, blArray2);
            }
            containerOperations.container = array;
            ((EditorBody)eventObject).containerOperations.findDomains();
            super.updateGUI();
            ((EditorBody)eventObject).attributesPanel.setAnchorAttributeIndex(n);
            ((EditorBody)eventObject).attributesPanel.refreshDomains();
            return;
        }
        if (eventObject == this.toolBar.fixTypesButton) {
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            ((EditorBody)eventObject).containerOperations.fixAttrTypes();
            ((EditorBody)eventObject).containerOperations.fixAttrValues();
            System.out.println("Types and Values of Attributes have been fixed.");
            super.updateGUI();
            return;
        }
        if (eventObject == this.toolBar.reloadButton) {
            this.updateMemory();
            this.updateGUI();
            return;
        }
        if (eventObject == this.filterPanel.filterButton) {
            eventObject = this;
            if (!((EditorBody)eventObject).containerOperations.isFileOpen()) return;
            ((EditorBody)eventObject).containerOperations.container = DiscFunctions.selectRows(((EditorBody)eventObject).containerOperations.container, ((EditorBody)eventObject).filterPanel.getFilter());
            ((EditorBody)eventObject).containerOperations.findDomains();
            super.updateGUI();
            return;
        }
        if (eventObject != this.attrFilterPanel.filterButton) {
            EditorBody editorBody;
            if (editorBody != this.dbConnectionWindow.dbConnectionPanel.runQueryButton) return;
            editorBody = this;
            if (!editorBody.containerOperations.loadFromDB(editorBody.dbConnectionWindow.dbConnectionPanel.getResultSet())) return;
            System.out.println("Query loaded.");
            editorBody.containerOperations.findDomains();
            editorBody.updateGUI();
            editorBody.dbConnectionWindow.setVisible(false);
            return;
        }
        eventObject = this;
        if (((EditorBody)eventObject).attrFilterPanel.importances == null) return;
        int n = ((EditorBody)eventObject).attrFilterPanel.importances.getMeasureIndex(((EditorBody)eventObject).attrFilterPanel.getMeasureName());
        boolean[] blArray = ((EditorBody)eventObject).attrFilterPanel.importances.getColMask(((EditorBody)eventObject).containerOperations.container, n, ((EditorBody)eventObject).attrFilterPanel.getAttrNumber(), ((EditorBody)eventObject).attrFilterPanel.inverseFiltering());
        if (blArray.length == ((EditorBody)eventObject).containerOperations.container.colsNumber()) {
            boolean[] blArray3 = new boolean[((EditorBody)eventObject).containerOperations.container.rowsNumber()];
            Arrays.fill(blArray3, true);
            ((EditorBody)eventObject).containerOperations.container = ((EditorBody)eventObject).containerOperations.container.clone(blArray, blArray3);
            super.updateGUI();
            return;
        }
        System.out.println("Number of attributes in histogram file does not match to current data set.");
    }

    private void updateMemory() {
        String[][] attr = this.attributesPanel.getAttributes();
        int attributesNumber = attr[0].length;
        TableModel model = this.eventsPanel.getModel();
        int columnsNumber = model.getColumnCount();
        int rowsNumber = model.getRowCount();
        SArray container = new SArray();
        ((Array)container).init(attributesNumber, rowsNumber);
        int i = 0;
        while (i < attributesNumber) {
            container.attributes[i].name = attr[0][i];
            container.attributes[i].type = Attribute.type2Int(attr[1][i]);
            ++i;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int i2 = 0;
        while (i2 < columnsNumber) {
            map.put(this.attributesPanel.getNewName(model.getColumnName(i2)), new Integer(i2));
            ++i2;
        }
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(attributesNumber * rowsNumber);
        int v = 0;
        int i3 = 0;
        while (i3 < attributesNumber) {
            int j = 0;
            while (j < rowsNumber) {
                int column = (Integer)map.get(container.attributes[i3].name);
                ((Array)container).writeValueStr(i3, j, model.getValueAt(j, column).toString());
                this.progressBar.setValue(v++);
                ++j;
            }
            ++i3;
        }
        String decName = this.attributesPanel.getNewName(this.attributesPanel.getDecisionAttributeName());
        container.setDecAttrIdx(container.getColIndex(decName));
        ((Array)container).setAllDecValues();
        SArray sArray = container;
        ContainerOperations containerOperations = this.containerOperations;
        this.containerOperations.container = sArray;
        this.containerOperations.findDomains();
        System.out.println("Container has been successfully reloaded.");
    }

    /*
     * WARNING - void declaration
     */
    private void updateGUI() {
        void attributes;
        this.eventsPanel.fillEventsTable();
        ContainerOperations containerOperations = this.containerOperations;
        String[][] stringArray = new String[2][containerOperations.container.attributes.length];
        int n = 0;
        while (n < containerOperations.container.attributes.length) {
            stringArray[0][n] = containerOperations.container.attributes[n].name;
            stringArray[1][n] = Attribute.type2String(containerOperations.container.attributes[n].type);
            ++n;
        }
        this.attributesPanel.setAttributes((String[][])attributes);
        containerOperations = this.containerOperations;
        this.attributesPanel.setDomains(((SArray)containerOperations.container).domains);
        int decIndex = this.containerOperations.container.getDecAttrIdx();
        if (decIndex != -1) {
            void var2_2;
            this.attributesPanel.setDecisionAttribute(this.containerOperations.container.attributes[var2_2].name);
        }
        this.attributesPanel.refreshDomains();
        this.replacePanel.setAttributes(stringArray[0]);
    }
}

