/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.RevisionUtils;
import weka.core.neighboursearch.PerformanceStats;

public class TreePerformanceStats
extends PerformanceStats {
    private static final long serialVersionUID = -6637636693340810373L;
    protected int m_MinLeaves;
    protected int m_MaxLeaves;
    protected int m_SumLeaves;
    protected int m_SumSqLeaves;
    protected int m_LeafCount;
    protected int m_MinIntNodes;
    protected int m_MaxIntNodes;
    protected int m_SumIntNodes;
    protected int m_SumSqIntNodes;
    protected int m_IntNodeCount;

    public TreePerformanceStats() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.m_LeafCount = 0;
        this.m_SumSqLeaves = 0;
        this.m_SumLeaves = 0;
        this.m_MinLeaves = Integer.MAX_VALUE;
        this.m_MaxLeaves = Integer.MIN_VALUE;
        this.m_IntNodeCount = 0;
        this.m_SumSqIntNodes = 0;
        this.m_SumIntNodes = 0;
        this.m_MinIntNodes = Integer.MAX_VALUE;
        this.m_MaxIntNodes = Integer.MIN_VALUE;
    }

    @Override
    public void searchStart() {
        super.searchStart();
        this.m_LeafCount = 0;
        this.m_IntNodeCount = 0;
    }

    @Override
    public void searchFinish() {
        super.searchFinish();
        this.m_SumLeaves += this.m_LeafCount;
        this.m_SumSqLeaves += this.m_LeafCount * this.m_LeafCount;
        if (this.m_LeafCount < this.m_MinLeaves) {
            this.m_MinLeaves = this.m_LeafCount;
        }
        if (this.m_LeafCount > this.m_MaxLeaves) {
            this.m_MaxLeaves = this.m_LeafCount;
        }
        this.m_SumIntNodes += this.m_IntNodeCount;
        this.m_SumSqIntNodes += this.m_IntNodeCount * this.m_IntNodeCount;
        if (this.m_IntNodeCount < this.m_MinIntNodes) {
            this.m_MinIntNodes = this.m_IntNodeCount;
        }
        if (this.m_IntNodeCount > this.m_MaxIntNodes) {
            this.m_MaxIntNodes = this.m_IntNodeCount;
        }
    }

    public void incrLeafCount() {
        ++this.m_LeafCount;
    }

    public void incrIntNodeCount() {
        ++this.m_IntNodeCount;
    }

    public int getTotalLeavesVisited() {
        return this.m_SumLeaves;
    }

    public double getMeanLeavesVisited() {
        return (double)this.m_SumLeaves / (double)this.m_NumQueries;
    }

    public double getStdDevLeavesVisited() {
        return Math.sqrt(((double)this.m_SumSqLeaves - (double)(this.m_SumLeaves * this.m_SumLeaves) / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public int getMinLeavesVisited() {
        return this.m_MinLeaves;
    }

    public int getMaxLeavesVisited() {
        return this.m_MaxLeaves;
    }

    public int getTotalIntNodesVisited() {
        return this.m_SumIntNodes;
    }

    public double getMeanIntNodesVisited() {
        return (double)this.m_SumIntNodes / (double)this.m_NumQueries;
    }

    public double getStdDevIntNodesVisited() {
        return Math.sqrt(((double)this.m_SumSqIntNodes - (double)(this.m_SumIntNodes * this.m_SumIntNodes) / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public int getMinIntNodesVisited() {
        return this.m_MinIntNodes;
    }

    public int getMaxIntNodesVisited() {
        return this.m_MaxIntNodes;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector newVector = new Vector();
        Enumeration en = super.enumerateMeasures();
        while (en.hasMoreElements()) {
            newVector.addElement(en.nextElement());
        }
        newVector.addElement("measureTotal_nodes_visited");
        newVector.addElement("measureMean_nodes_visited");
        newVector.addElement("measureStdDev_nodes_visited");
        newVector.addElement("measureMin_nodes_visited");
        newVector.addElement("measureMax_nodes_visited");
        newVector.addElement("measureTotal_leaves_visited");
        newVector.addElement("measureMean_leaves_visited");
        newVector.addElement("measureStdDev_leaves_visited");
        newVector.addElement("measureMin_leaves_visited");
        newVector.addElement("measureMax_leaves_visited");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) throws IllegalArgumentException {
        if (additionalMeasureName.compareToIgnoreCase("measureTotal_nodes_visited") == 0) {
            return this.getTotalIntNodesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMean_nodes_visited") == 0) {
            return this.getMeanIntNodesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureStdDev_nodes_visited") == 0) {
            return this.getStdDevIntNodesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMin_nodes_visited") == 0) {
            return this.getMinIntNodesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMax_nodes_visited") == 0) {
            return this.getMaxIntNodesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTotal_leaves_visited") == 0) {
            return this.getTotalLeavesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMean_leaves_visited") == 0) {
            return this.getMeanLeavesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureStdDev_leaves_visited") == 0) {
            return this.getStdDevLeavesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMin_leaves_visited") == 0) {
            return this.getMinLeavesVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMax_leaves_visited") == 0) {
            return this.getMaxLeavesVisited();
        }
        return super.getMeasure(additionalMeasureName);
    }

    @Override
    public String getStats() {
        StringBuffer buf = new StringBuffer(super.getStats());
        buf.append("leaves:    " + this.getMinLeavesVisited() + ", " + this.getMaxLeavesVisited() + "," + this.getTotalLeavesVisited() + "," + this.getMeanLeavesVisited() + ", " + this.getStdDevLeavesVisited() + "\n");
        buf.append("Int nodes: " + this.getMinIntNodesVisited() + ", " + this.getMaxIntNodesVisited() + "," + this.getTotalIntNodesVisited() + "," + this.getMeanIntNodesVisited() + ", " + this.getStdDevIntNodesVisited() + "\n");
        return buf.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

