/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.AbstractStringDistanceFunction;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class EditDistance
extends AbstractStringDistanceFunction {
    public EditDistance() {
    }

    public EditDistance(Instances data) {
        super(data);
    }

    @Override
    double stringDistance(String stringA, String stringB) {
        int lengthA = stringA.length();
        int lengthB = stringB.length();
        double[][] distanceMatrix = new double[lengthA + 1][lengthB + 1];
        int i = 0;
        while (i <= lengthA) {
            distanceMatrix[i][0] = i;
            ++i;
        }
        int j = 1;
        while (j <= lengthB) {
            distanceMatrix[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= lengthA) {
            int j2 = 1;
            while (j2 <= lengthB) {
                distanceMatrix[i][j2] = stringA.charAt(i - 1) == stringB.charAt(j2 - 1) ? distanceMatrix[i - 1][j2 - 1] : 1.0 + Math.min(distanceMatrix[i - 1][j2], Math.min(distanceMatrix[i][j2 - 1], distanceMatrix[i - 1][j2 - 1]));
                ++j2;
            }
            ++i;
        }
        return distanceMatrix[lengthA][lengthB];
    }

    @Override
    public String globalInfo() {
        return "Implementing Levenshtein distance function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see: http://en.wikipedia.org/wiki/Levenshtein_distance\n\n";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

