/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.FArray;
import dmLab.classifier.Params;
import dmLab.classifier.Prediction;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.cmatrix.ConfusionMatrix;
import java.io.IOException;
import java.util.HashSet;

public abstract class Classifier {
    public Params params;
    public String label = "classifier";
    protected int classifierID = 0;
    protected ConfusionMatrix confusionMatrix;
    protected String tmpPath = "";
    protected float learningTime = 0.0f;
    protected float testingTime = 0.0f;
    protected int trainSetSize;
    protected Prediction[] predictions;
    protected HashSet<String> attrSet;
    public static int ENSEMBLE = 0;
    public static int RND = 1;
    public static int J48 = 2;
    public static int ADX = 3;
    public static int SLIQ = 4;
    public static int RF = 5;
    public static int NB = 6;
    public static int SVM = 7;
    public static int KNN = 8;
    public static int RIPPER = 9;
    public static int BNET = 10;
    public static int HP = 11;
    public static int LOGISTIC = 12;
    public static String[] labels = new String[]{"ensemble", "rnd", "j48", "adx", "sliq", "rf", "nb", "svm", "knn", "ripper", "bayesNet", "hyperPipes", "logistic"};

    /*
     * WARNING - void declaration
     */
    public final void setClassifierId(int id) {
        void var1_1;
        this.classifierID = var1_1;
    }

    public final String getMyName() {
        return String.valueOf(this.label) + "_C" + this.classifierID;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTempPath(String tempPath) {
        void var1_1;
        this.tmpPath = var1_1;
    }

    public final double getLearningTime() {
        return this.learningTime;
    }

    public final double getTestingTime() {
        return this.testingTime;
    }

    public abstract boolean train(FArray var1);

    public abstract boolean test(FArray var1);

    public abstract boolean init();

    public abstract boolean finish();

    public abstract String toString();

    public String toString(boolean header) {
        return this.toString();
    }

    public abstract boolean saveDefinition(String var1, String var2) throws IOException;

    public abstract boolean addImportances(AttributesRI[] var1);

    public boolean addIDependencies(AttributesID attrIDependencies, MCFSParams params) {
        if (this.attrSet == null || this.attrSet.size() == 0) {
            return false;
        }
        Object[] attr = this.attrSet.toArray();
        int i = 0;
        while (i < attr.length) {
            int j = 0;
            while (j < attr.length) {
                if (i != j) {
                    attrIDependencies.addDependency((String)attr[i], (String)attr[j], 1.0f);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public final Prediction[] getPredictions() {
        return this.predictions;
    }

    public static String int2label(int id) {
        int n;
        if (id < 0 || id >= labels.length) {
            return "";
        }
        return labels[n];
    }

    public static int label2int(String label) {
        int i = 0;
        while (i < labels.length) {
            if (label.equalsIgnoreCase(labels[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

