#' 25 search results for "Oakland Public library branch"
#'
#' Contains the search results from Mapzen's search service for the query
#' "Oakland public library branch" as of January 8, 2017.
#'
#' @format A \code{mapzen_geo_list} with 25 locations
#'
#' @source Mapzen, OpenStreetMap, OpenAddresses, GeoNames, WhosOnFirst,
#' see \url{https://www.mapzen.com/rights/}
"oakland_public"

#' Pedestrian isochrones from the Berkeley Marina for 10 and 15 minutes
#'
#' Isochrone results from Mapzen as of January 8, 2017. The location for the
#' isochrones is the Berkeley Marina, lat 37.86613, lon -122.3151
#'
#' @source Mapzen, OpenStreetMap, British Oceanographic Data Centre,
#' NASA, USGS, and Transitland.
"marina_walks"

#' Vector tiles the contain California
#'
#' @source Mapzen, OpenStreetMap contributors, Who's On First, Natural Earth,
#' and openstreetmapdata.com
"ca_tiles"

#' Pedestrian isochrones from the Berkeley Marina for 10 and 15 minutes, as polygons
#'
#' Polygon Isochrone results (using \code{polygons = TRUE}) from Mapzen as of
#' January 10, 2017. The location for the isochrones is the Berkeley Marina,
#' lat 37.86613, lon -122.3151, and the contours are 10 and 15 minutes for a
#' pedestrian costing model.
#'
#' @source Mapzen, OpenStreetMap, British Oceanographic Data Centre,
#' NASA, USGS, and Transitland.
"marina_walks_polygons"
