% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rRule.R
\name{rRule}
\alias{rRule}
\title{Rule for running R scripts}
\usage{
rRule(target, script, depends = NULL, params = NULL, task = "all")
}
\arguments{
\item{target}{Name of output files to be created}

\item{script}{Name of the R script to be executed}

\item{depends}{A vector of file names that the R script depends on, or \code{NULL}.}

\item{params}{\code{NULL} or a list of R values that become available within the \code{script} in
a \code{params} variable.}

\item{task}{A character vector of parent task names. The mechanism of tasks allows to
group rules. Anything different from \code{'all'} will
cause creation of a new task depending on the given rule. Executing \code{make taskname}
will then force building of this rule.}
}
\value{
Instance of S3 class \code{rmake.rule}
}
\description{
This rule is for execution of R scripts in order to create various file outputs.
}
\details{
In detail, this rule executes the following command in a separate R process:
\code{params <- params; source(script)}

Issuing \code{make clean} from the shell causes removal of all files specified in \code{target} parameter.
}
\examples{
r <- rRule(target='cleandata.csv',
           script='clean.R',
           depends=c('data1.csv', 'data2.csv'))

# generate the content of a makefile (as character vector)
makefile(list(r))

# generate to file
tmp <- tempdir()
makefile(list(r), file.path(tmp, "Makefile"))
}
\seealso{
\code{\link[=rule]{rule()}}, \code{\link[=makefile]{makefile()}}, \code{\link[=markdownRule]{markdownRule()}}
}
\author{
Michal Burda
}
