% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings_methods.R
\name{make_row_df,listing_df-method}
\alias{make_row_df,listing_df-method}
\title{Make pagination dataframe for a listing}
\usage{
\S4method{make_row_df}{listing_df}(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = character(),
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_
)
}
\arguments{
\item{tt}{listing_df. The listing to be rendered}

\item{colwidths}{numeric. Internal detail do not set manually.}

\item{visible_only}{logical(1). Ignored, as listings
do not have non-visible structural elements.}

\item{rownum}{numeric(1). Internal detail do not set manually.}

\item{indent}{integer(1). Internal detail do not set manually.}

\item{path}{character.  Path  to  the (sub)table  represented  by
\code{tt}. Defaults to \code{character()}}

\item{incontent}{logical(1). Internal detail do not set manually.}

\item{repr_ext}{integer(1). Internal detail do not set manually.}

\item{repr_inds}{integer. Internal detail do not set manually.}

\item{sibpos}{integer(1). Internal detail do not set manually.}

\item{nsibs}{integer(1). Internal detail do not set manually.}
}
\value{
a data.frame with pagination information.
}
\description{
Make pagination dataframe for a listing
}
\examples{
lsting <- as_listing(mtcars)
mf <- matrix_form(lsting)

}
\seealso{
\code{\link[formatters]{make_row_df}}
}
