% Generated by roxygen2 (4.0.1): do not edit by hand
\name{List}
\alias{List}
\title{List wrapper environment in which \code{data} is the \code{list} and
most list functions are defined for chainable operations.}
\usage{
List(data = list())
}
\arguments{
\item{data}{\code{list}}
}
\description{
List wrapper environment in which \code{data} is the \code{list} and
most list functions are defined for chainable operations.
}
\details{
Most list functions are defined in the wrapper environment.
In addition to these functions, \code{call(fun,...)} calls
external function \code{fun} with additional parameters specifies in
\code{...}.

To extract the data from List \code{x}, call \code{x$data}.
}
\examples{
\dontrun{
x <- list(p1 = list(type="A",score=list(c1=10,c2=8)),
       p2 = list(type="B",score=list(c1=9,c2=9)),
       p3 = list(type="B",score=list(c1=9,c2=7)))
m <- List(x)
m$filter(type=="B")$
  map(score$c1) []

m$group(type)$
  map(g -> List(g)$
      map(score)$
      call(unlist)$
      call(mean) []) []
}
}

