% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEA.R
\name{runGSEA}
\alias{runGSEA}
\title{Analyze biological interpretations of metagene}
\usage{
runGSEA(
  object,
  genesets = NULL,
  useW = TRUE,
  useV = NULL,
  customGenesets = NULL,
  gene_sets = genesets,
  mat_w = useW,
  mat_v = useV,
  custom_gene_sets = customGenesets
)
}
\arguments{
\item{object}{A \linkS4class{liger} object with valid factorization result.}

\item{genesets}{Character vector of the Reactome gene sets names to be
tested. Default \code{NULL} uses all the gene sets from the Reactome.}

\item{useW}{Logical, whether to use the shared factor loadings (\eqn{W}).
Default \code{TRUE}.}

\item{useV}{A character vector of the names, a numeric or logical
vector of the index of the datasets where the \eqn{V} matrices will be
included for analysis. Default \code{NULL} uses all datasets.}

\item{customGenesets}{A named list of character vectors of entrez gene ids.
Default \code{NULL} uses all the gene symbols from the input matrix.}

\item{gene_sets, mat_w, mat_v, custom_gene_sets}{\bold{Deprecated}. See Usage
section for replacement.}
}
\value{
A list of matrices with GSEA analysis for each factor
}
\description{
Identify the biological pathways (gene sets from Reactome) that
each metagene (factor) might belongs to.
}
\examples{
\donttest{
runGSEA(pbmcPlot)
}
}
