% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{removeMissing}
\alias{removeMissing}
\alias{removeMissingObs}
\title{Remove missing cells or features from liger object}
\usage{
removeMissing(
  object,
  orient = c("both", "feature", "cell"),
  minCells = NULL,
  minFeatures = NULL,
  useDatasets = NULL,
  newH5 = TRUE,
  filenameSuffix = "removeMissing",
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

removeMissingObs(
  object,
  slot.use = NULL,
  use.cols = TRUE,
  verbose = getOption("ligerVerbose", TRUE)
)
}
\arguments{
\item{object}{\linkS4class{liger} object}

\item{orient}{Choose to remove non-expressing features (\code{"feature"}),
empty barcodes (\code{"cell"}), or both of them (\code{"both"}). Default
\code{"both"}.}

\item{minCells}{Keep features that are expressed in at least this number of
cells, calculated on a per-dataset base. A single value for all datasets or
a vector for each dataset. Default \code{NULL} only removes none expressing
features.}

\item{minFeatures}{Keep cells that express at least this number of features,
calculated on a per-dataset base. A single value for all datasets or a vector
for each dataset. Default \code{NULL} only removes none expressing cells.}

\item{useDatasets}{A character vector of the names, a numeric or logical
vector of the index of the datasets to be processed. Default
\code{NULL} removes empty entries from all datasets.}

\item{newH5}{Logical, whether to create a new H5 file on disk for each
H5-based dataset on subset. Default \code{TRUE}}

\item{filenameSuffix}{When subsetting H5-based datasets to new H5 files, this
suffix will be added to all the filenames. Default \code{"removeMissing"}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{...}{Arguments passed to \code{\link{subsetLigerDataset}}}

\item{slot.use}{\bold{Deprecated}. Always look at \code{rawData} slot of
inner \linkS4class{ligerDataset} objects.}

\item{use.cols}{\bold{Deprecated}. Previously means "treating each column as
a cell" when \code{TRUE}, now means \code{orient="cell"}.}
}
\value{
Updated (subset) \code{object}.
}
\description{
Remove missing cells or features from liger object
}
\note{
\code{removeMissingObs} will be deprecated. \code{removeMissing} covers and
expands the use case and should be easier to understand.
}
\examples{
# The example dataset does not contain non-expressing genes or empty barcodes
pbmc <- removeMissing(pbmc)
}
