% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{logMargPostFun.Kriging}
\alias{logMargPostFun.Kriging}
\alias{logMargPostFun,Kriging,Kriging-method}
\title{Compute the log-marginal posterior of a kriging model, using the
prior XXXY.}
\usage{
\method{logMargPostFun}{Kriging}(object, theta, return_grad = FALSE, bench = FALSE, ...)
}
\arguments{
\item{object}{S3 Kriging object.}

\item{theta}{Numeric vector of correlation range parameters at
which the function is to be evaluated.}

\item{return_grad}{Logical. Should the function return the gradient
(w.r.t theta)?}

\item{bench}{Logical. Should the function display benchmarking output?}

\item{...}{Not used.}
}
\value{
The value of the log-marginal posterior computed for the
    given vector theta.
}
\description{
Compute the log-marginal posterior of a kriging model, using the
prior XXXY.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, "matern3_2", objective="LMP")
print(k)

lmp <- function(theta) logMargPostFun(k, theta)$logMargPost

t <- seq(from = 0.01, to = 2, length.out = 101)
plot(t, lmp(t), type = "l")
abline(v = k$theta(), col = "blue")
}
\references{
XXXY A reference describing the model (prior, ...)
}
\seealso{
\code{\link[RobustGaSP]{rgasp}} in the RobustGaSP package.
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
