% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{leaveOneOutVec.Kriging}
\alias{leaveOneOutVec.Kriging}
\alias{leaveOneOutVec,Kriging,Kriging-method}
\title{Compute Leave-One-Out (LOO) vector error for an object with S3 class
\code{"Kriging"} representing a kriging model.}
\usage{
\method{leaveOneOutVec}{Kriging}(object, theta, ...)
}
\arguments{
\item{object}{A \code{Kriging} object.}

\item{theta}{A numeric vector of range parameters at which the LOO
will be evaluated.}

\item{...}{Not used.}
}
\value{
The leave-One-Out vector computed for the given vector
    \eqn{\boldsymbol{\theta}}{\theta} of correlation ranges.
}
\description{
The returned value is the mean and stdev of \eqn{\hat{y}_{i,(-i)}}, the
prediction of \eqn{y_i}{y[i]} based on the the observations \eqn{y_j}{y[j]}
with \eqn{j \neq i}{j != i}.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective = "LOO", optim="BFGS")
print(k)

leaveOneOutVec(k, k$theta())
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
