% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{update.Kriging}
\alias{update.Kriging}
\title{Update a \code{Kriging} model object with new points}
\usage{
\method{update}{Kriging}(object, newy, newX, ...)
}
\arguments{
\item{object}{S3 Kriging object.}

\item{newy}{Numeric vector of new responses (output).}

\item{newX}{Numeric matrix of new input points.}

\item{...}{Ignored.}
}
\value{
No return value. Kriging object argument is modified.
}
\description{
Update a \code{Kriging} model object with new points
}
\section{Caution}{
 The method \emph{does not return the updated
    object}, but instead changes the content of
    \code{object}. This behaviour is quite unusual in R and
    differs from the behaviour of the methods
    \code{\link[DiceKriging]{update.km}} in \pkg{DiceKriging} and
    \code{\link{update,KM-method}}.
}

\examples{
f <- function(x) 1- 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x)*x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)
points(X, y, col = "blue")

k <- Kriging(y, X, "matern3_2")

x <- seq(from = 0, to = 1, length.out = 101)
p <- predict(k, x)
lines(x, p$mean, col = "blue")
polygon(c(x, rev(x)), c(p$mean - 2 * p$stdev, rev(p$mean + 2 * p$stdev)),
 border = NA, col = rgb(0, 0, 1, 0.2))

newX <- as.matrix(runif(3))
newy <- f(newX)
points(newX, newy, col = "red")

## change the content of the object 'k'
update(k, newy, newX)

x <- seq(from = 0, to = 1, length.out = 101)
p2 <- predict(k, x)
lines(x, p2$mean, col = "red")
polygon(c(x, rev(x)), c(p2$mean - 2 * p2$stdev, rev(p2$mean + 2 * p2$stdev)),
 border = NA, col = rgb(1, 0, 0, 0.2))
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
