% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxmatching.R
\name{MaxCardinalityMatching}
\alias{MaxCardinalityMatching}
\title{MaxCardinalityMatching}
\usage{
MaxCardinalityMatching(
  arcSources,
  arcTargets,
  numNodes,
  algorithm = "MaxMatching"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{What algorithm you want to run. Choices include
"MaxMatching", "MaxFractionalMatching" where "MaxMatching" is the default.
See <https://lemon.cs.elte.hu/pub/doc/1.3.1/a00615.html> for details on the
differences.}
}
\value{
A list containing two entries: 1) The matching value, 2) The edges
  of the final graph, in a List of List of (node, node) pairs
}
\description{
Finds the maximum cardinality matching in graphs and
bipartite graphs.
}
