% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_hist}
\alias{lc_hist}
\alias{lc_dens}
\title{Histograms and density plots}
\usage{
lc_hist(data = list(), place = NULL, ..., id = NULL,
  layerId = NULL, addLayer = FALSE)

lc_dens(data = list(), place = NULL, ..., id = NULL,
  layerId = NULL, addLayer = FALSE)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{An ID of a container, where to place the chart. Will be ignored if the chart already
exists. If not defined, the chart will be placed directly in the body of the opened page.}

\item{...}{Name value pairs of properties that can be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function}

\item{id}{An ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, a new layer will be added to it. If you want to replace one chart with another, use \code{\link{removeChart}}
first. If not defined, the ID will be set to \code{ChartN}, where \code{N - 1} is the number of currently existing charts.}

\item{layerId}{An ID for the new layer. All layers within one chart must have different IDs. If a layer with the same
ID already exists, it will be replaced. If not defined, will be set to \code{LayerN}, where \code{N - 1}
is the number of currently existing layers in this chart.}

\item{addLayer}{whether to add a new layer or to replace the existing one. This argument influences the chart only if
it has only one layer and the \code{layerId} is not defined.}
}
\description{
These functions make either a histogram or a density plot of the given data
and either add them as a new layer to an existing chart or create a new chart.
}
\section{Functions}{
\itemize{
\item \code{lc_hist}: makes a histogram. It is an extension of \code{\link{lc_bars}}.

\item \code{lc_dens}: makes a density plot. Is an extension of \code{\link{lc_line}}.
}}

\section{Available properties}{


\itemize{
\item \code{value} - vector of data.
\item \code{nbins} - (only for \code{lc_hist}) number of bins.}

These functions are extensions of \code{\link{lc_line}} (\code{lc_dens}) or \code{\link{lc_bars}}
(\code{lc_hist}) and therefore can also understand their properties.
}

\examples{
\donttest{
lc_hist(dat(value = rnorm(1000), nbins = 30, height = 300))
lc_dens(dat(value = rnorm(1000), height = 300)) }

}
