% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{read.las}
\alias{read.las}
\title{Read data from a .las or .laz file}
\usage{
read.las(files, select = "*", filter = "", transform = "")
}
\arguments{
\item{files}{array of characters}

\item{select}{character. select only columns of interest to save memory (see details)}

\item{filter}{character. streaming filters - filter data while reading the file (see details)}

\item{transform}{character. streaming transformation - transform data while reading the file (see details)}
}
\value{
A \code{data.table}
}
\description{
Reads data from .las or .laz files according to LAS specifications and returns
a \code{data.table} labelled according to LAS specifications. See the ASPRS documentation for the
\href{https://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS file format}.
The optional parameters enable the user to save memory by choosing to load only the
attributes they need. Moreover, the function provides a streaming filter to load only the points of
interest into the memory and hence avoids allocating any superfluous memory.
}
\details{
\strong{Select:} the 'select' argument specifies the data that will actually be loaded. For example,
'xyzia' means that the x, y, and z coordinates, the intensity and the scan angle will be loaded.
The supported entries are t - gpstime, a - scan angle, i - intensity, n - number of returns,
r - return number, c - classification, s - synthetic flag, k - keypoint flag, w - withheld flag,
o - overlap flag (format 6+), u - user data, p - point source ID, e - edge of flight line flag,
d - direction of scan flag, R - red channel of RGB color, G - green channel of RGB color,
B - blue channel of RGB color, N - near-infrared channel, C - scanner channel (format 6+),
W - Full waveform.
Also numbers from 1 to 9 for the extra bytes data numbers 1 to 9. 0 enables all extra bytes to be
loaded and '*' is the wildcard that enables everything to be loaded from the LAS file. \cr
Note that x, y, z are implicit and always loaded. 'xyzia' is equivalent to 'ia'.\cr\cr
\strong{Filter:} the 'filter' argument allows filtering of the point cloud while reading files.
\code{rlas} relies on the well-known \code{LASlib} library written by Martin Isenburg
to read the binary files. Thus the package inherits the filter commands available in
\href{https://rapidlasso.com/lastools/}{LAStools}. To use these filters the user can pass the
common commands from \code{LAStools} into the parameter \code{'filter'}. Type \code{read.las(filter = "-help")}
to display the \code{LASlib} documentation and the available filters.\cr\cr
\strong{Transform:} the 'transform' argument allows transformation of the point cloud while reading files.
\code{rlas} relies on the well-known \code{LASlib} library written by Martin Isenburg
to read the binary files. Thus the package inherits the tranform commands available in
\href{https://rapidlasso.com/lastools/}{LAStools}. To use these transformations the user can pass the
common commands from \code{LAStools} into the parameter \code{'transform'}. Type \code{read.las(transform = "-help")}
to display the \code{LASlib} documentation and the available transformations.
}
\section{Full Waveform}{

The support of full waveform is still in development. The version 1.4.1 introduced the
support of point formats 4, 5, 9 and 10. The current state consists in reading the raw data.
We also introduced the function \link{fwf_interpreter} to interpret the raw data into something
easier to manipulate (but that uses more memory). The current behaviour is not set
in stone and is prone to design modification until version 1.5.0 where we aims to
get enough insight to lock our engineering choices to something that suit best the needs.
}

\examples{
lasfile <- system.file("extdata", "example.las", package="rlas")

lasdata <- read.las(lasfile)
lasdata <- read.las(lasfile, filter = "-keep_first")
lasdata <- read.las(lasfile, filter = "-drop_intensity_below 80")
lasdata <- read.las(lasfile, select = "xyzia")
}
