% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-new.R
\name{rep_along}
\alias{rep_along}
\alias{rep_named}
\title{Create vectors matching the length of a given vector}
\usage{
rep_along(along, x)

rep_named(names, x)
}
\arguments{
\item{along}{Vector whose length determine how many times \code{x}
is repeated.}

\item{x}{Values to repeat.}

\item{names}{Names for the new vector. The length of \code{names}
determines how many times \code{x} is repeated.}
}
\description{
These functions take the idea of \code{\link[=seq_along]{seq_along()}} and apply it to
repeating values.
}
\examples{
x <- 0:5
rep_along(x, 1:2)
rep_along(x, 1)

# Create fresh vectors by repeating missing values:
rep_along(x, na_int)
rep_along(x, na_chr)

# rep_named() repeats a value along a names vectors
rep_named(c("foo", "bar"), list(letters))
}
\seealso{
new-vector
}
