% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{type-predicates}
\alias{type-predicates}
\alias{is_list}
\alias{is_atomic}
\alias{is_vector}
\alias{is_integer}
\alias{is_double}
\alias{is_character}
\alias{is_logical}
\alias{is_raw}
\alias{is_bytes}
\alias{is_null}
\title{Type predicates}
\usage{
is_list(x, n = NULL)

is_atomic(x, n = NULL)

is_vector(x, n = NULL)

is_integer(x, n = NULL)

is_double(x, n = NULL, finite = NULL)

is_character(x, n = NULL, encoding = NULL)

is_logical(x, n = NULL)

is_raw(x, n = NULL)

is_bytes(x, n = NULL)

is_null(x)
}
\arguments{
\item{x}{Object to be tested.}

\item{n}{Expected length of a vector.}

\item{finite}{Whether all values of the vector are finite. The
non-finite values are \code{NA}, \code{Inf}, \code{-Inf} and \code{NaN}. Setting this
to something other than \code{NULL} can be expensive because the whole
vector needs to be traversed and checked.}

\item{encoding}{Defunct as of rlang 0.4.0.}
}
\description{
These type predicates aim to make type testing in R more
consistent. They are wrappers around \code{\link[base:typeof]{base::typeof()}}, so operate
at a level beneath S3/S4 etc.
}
\details{
Compared to base R functions:
\itemize{
\item The predicates for vectors include the \code{n} argument for
pattern-matching on the vector length.
\item Unlike \code{is.atomic()}, \code{is_atomic()} does not return \code{TRUE} for
\code{NULL}.
\item Unlike \code{is.vector()}, \code{is_vector()} tests if an object is an
atomic vector or a list. \code{is.vector} checks for the presence of
attributes (other than name).
}
}
\seealso{
\link{bare-type-predicates} \link{scalar-type-predicates}
}
