% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-squash.R
\name{flatten}
\alias{flatten}
\alias{flatten_lgl}
\alias{flatten_int}
\alias{flatten_dbl}
\alias{flatten_cpl}
\alias{flatten_chr}
\alias{flatten_raw}
\alias{squash}
\alias{squash_lgl}
\alias{squash_int}
\alias{squash_dbl}
\alias{squash_cpl}
\alias{squash_chr}
\alias{squash_raw}
\alias{flatten_if}
\alias{squash_if}
\title{Flatten or squash a list of lists into a simpler vector}
\usage{
flatten(x)

flatten_lgl(x)

flatten_int(x)

flatten_dbl(x)

flatten_cpl(x)

flatten_chr(x)

flatten_raw(x)

squash(x)

squash_lgl(x)

squash_int(x)

squash_dbl(x)

squash_cpl(x)

squash_chr(x)

squash_raw(x)

flatten_if(x, predicate = is_spliced)

squash_if(x, predicate = is_spliced)
}
\arguments{
\item{x}{A list of flatten or squash. The contents of the list can
be anything for unsuffixed functions \code{flatten()} and \code{squash()}
(as a list is returned), but the contents must match the type for
the other functions.}

\item{predicate}{A function of one argument returning whether it
should be spliced.}
}
\value{
\code{flatten()} returns a list, \code{flatten_lgl()} a logical
vector, \code{flatten_int()} an integer vector, \code{flatten_dbl()} a
double vector, and \code{flatten_chr()} a character vector. Similarly
for \code{squash()} and the typed variants (\code{squash_lgl()} etc).
}
\description{
\code{flatten()} removes one level hierarchy from a list, while
\code{squash()} removes all levels. These functions are similar to
\code{\link[=unlist]{unlist()}} but they are type-stable so you always know what the
type of the output is.
}
\examples{
x <- replicate(2, sample(4), simplify = FALSE)
x

flatten(x)
flatten_int(x)

# With flatten(), only one level gets removed at a time:
deep <- list(1, list(2, list(3)))
flatten(deep)
flatten(flatten(deep))

# But squash() removes all levels:
squash(deep)
squash_dbl(deep)

# The typed flattens remove one level and coerce to an atomic
# vector at the same time:
flatten_dbl(list(1, list(2)))

# Only bare lists are flattened, but you can splice S3 lists
# explicitly:
foo <- set_attrs(list("bar"), class = "foo")
str(flatten(list(1, foo, list(100))))
str(flatten(list(1, splice(foo), list(100))))

# Instead of splicing manually, flatten_if() and squash_if() let
# you specify a predicate function:
is_foo <- function(x) inherits(x, "foo") || is_bare_list(x)
str(flatten_if(list(1, foo, list(100)), is_foo))

# squash_if() does the same with deep lists:
deep_foo <- list(1, list(foo, list(foo, 100)))
str(deep_foo)

str(squash(deep_foo))
str(squash_if(deep_foo, is_foo))
}
