% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-get_options.R
\name{get_rkeops_option}
\alias{get_rkeops_option}
\title{Get the current value of a specific compile or runtime options of \code{rkeops}}
\usage{
get_rkeops_option(option)
}
\arguments{
\item{option}{string, name of the options to set up (see Details).}
}
\value{
the value of the requested option (see Details).
}
\description{
The function \code{get_rkeops_option} returns the current value of a specific
\code{rkeops} option (in \code{R} global options scope) provided as input.
}
\details{
\code{rkeops} global options includes two lists defining options used at
compilation of user-defined operators or at runtime. These two list
contains specific informations (see \code{\link[=compile_options]{compile_options()}} and
\code{\link[=runtime_options]{runtime_options()}} respectively, in particular for default values).

With the function \code{get_rkeops_option}, you get the value of a specific
\code{rkeops} option among:
\itemize{
\item \code{rkeops} compile options: rkeops_dir\verb{(not recommended),}build_dir\verb{,  }src_dir\verb{(not recommended),}precision\verb{, }verbosity\verb{,  }use_cuda_if_possible\verb{, }col_major\verb{(not recommended),}debug`
\item \code{rkeops} runtime options: \code{tagCpuGpu}, \code{tag1D2D}, \code{tagHostDevice},
\code{device_id}
These options are set with the functions \code{\link[=set_rkeops_options]{set_rkeops_options()}} and
\code{\link[=set_rkeops_option]{set_rkeops_option()}}. To know which values are allowed for which
options, you can check \code{\link[=compile_options]{compile_options()}} and
\code{\link[=runtime_options]{runtime_options()}}.
}
}
\examples{
library(rkeops)
# to get the GPU id used for computations
get_rkeops_option("device_id")
}
\seealso{
\code{\link[=get_rkeops_options]{get_rkeops_options()}}, \code{\link[=compile_options]{compile_options()}},
\code{\link[=runtime_options]{runtime_options()}}, \code{\link[=set_rkeops_options]{set_rkeops_options()}},
\code{\link[=set_rkeops_option]{set_rkeops_option()}}
}
\author{
Ghislain Durif
}
