/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Map list = new LinkedHashMap();
    private static boolean encodeParameters = false;
    private static boolean decodeParameters = false;
    private static boolean decodeParametersStrict = false;
    private static final char[] hex;

    public ParameterList() {
    }

    public ParameterList(String s) throws ParseException {
        HeaderTokenizer.Token tk;
        HeaderTokenizer h = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        while (true) {
            int type;
            if ((type = (tk = h.next()).getType()) == -4) {
                return;
            }
            if ((char)type != ';') break;
            tk = h.next();
            if (tk.getType() == -4) {
                return;
            }
            if (tk.getType() != -1) {
                throw new ParseException("Expected parameter name, got \"" + tk.getValue() + "\"");
            }
            String name = tk.getValue().toLowerCase();
            tk = h.next();
            if ((char)tk.getType() != '=') {
                throw new ParseException("Expected '=', got \"" + tk.getValue() + "\"");
            }
            tk = h.next();
            type = tk.getType();
            if (type != -1 && type != -2) {
                throw new ParseException("Expected parameter value, got \"" + tk.getValue() + "\"");
            }
            String value2 = tk.getValue();
            if (decodeParameters && name.endsWith("*")) {
                name = name.substring(0, name.length() - 1);
                this.list.put(name, this.decodeValue(value2));
                continue;
            }
            this.list.put(name, value2);
        }
        throw new ParseException("Expected ';', got \"" + tk.getValue() + "\"");
    }

    public int size() {
        return this.list.size();
    }

    public String get(String name) {
        Object v = this.list.get(name.trim().toLowerCase());
        String value2 = v instanceof Value ? ((Value)v).value : (String)v;
        return value2;
    }

    public void set(String name, String value2) {
        this.list.put(name.trim().toLowerCase(), value2);
    }

    public void set(String name, String value2, String charset) {
        if (encodeParameters) {
            Value ev = this.encodeValue(value2, charset);
            if (ev != null) {
                this.list.put(name.trim().toLowerCase(), ev);
            } else {
                this.set(name, value2);
            }
        } else {
            this.set(name, value2);
        }
    }

    public void remove(String name) {
        this.list.remove(name.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return new ParamEnum(this.list.keySet().iterator());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        StringBuffer sb = new StringBuffer();
        Iterator e = this.list.keySet().iterator();
        while (e.hasNext()) {
            String value2;
            String name = (String)e.next();
            Object v = this.list.get(name);
            if (v instanceof Value) {
                value2 = ((Value)v).encodedValue;
                name = name + '*';
            } else {
                value2 = (String)v;
            }
            value2 = this.quote(value2);
            sb.append("; ");
            int len = name.length() + value2.length() + 1;
            if ((used += 2) + len > 76) {
                sb.append("\r\n\t");
                used = 8;
            }
            sb.append(name).append('=');
            if ((used += name.length() + 1) + value2.length() > 76) {
                String s = MimeUtility.fold(used, value2);
                sb.append(s);
                int lastlf = s.lastIndexOf(10);
                if (lastlf >= 0) {
                    used += s.length() - lastlf - 1;
                    continue;
                }
                used += s.length();
                continue;
            }
            sb.append(value2);
            used += value2.length();
        }
        return sb.toString();
    }

    private String quote(String value2) {
        return MimeUtility.quote(value2, "()<>@,;:\\\"\t []/?=");
    }

    private Value encodeValue(String value2, String charset) {
        byte[] b;
        if (MimeUtility.checkAscii(value2) == 1) {
            return null;
        }
        try {
            b = value2.getBytes(MimeUtility.javaCharset(charset));
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        StringBuffer sb = new StringBuffer(b.length + charset.length() + 2);
        sb.append(charset).append("''");
        for (int i = 0; i < b.length; ++i) {
            char c = (char)(b[i] & 0xFF);
            if (c <= ' ' || c >= '\u007f' || c == '*' || c == '\'' || c == '%' || "()<>@,;:\\\"\t []/?=".indexOf(c) >= 0) {
                sb.append('%').append(hex[c >> 4]).append(hex[c & 0xF]);
                continue;
            }
            sb.append(c);
        }
        Value v = new Value();
        v.value = value2;
        v.encodedValue = sb.toString();
        return v;
    }

    private Value decodeValue(String value2) throws ParseException {
        Value v;
        block12: {
            v = new Value();
            v.encodedValue = value2;
            v.value = value2;
            try {
                int i = value2.indexOf(39);
                if (i <= 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing charset in encoded value: " + value2);
                    }
                    return v;
                }
                String charset = value2.substring(0, i);
                int li = value2.indexOf(39, i + 1);
                if (li < 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing language in encoded value: " + value2);
                    }
                    return v;
                }
                String lang = value2.substring(i + 1, li);
                value2 = value2.substring(li + 1);
                byte[] b = new byte[value2.length()];
                int bi = 0;
                for (i = 0; i < value2.length(); ++i) {
                    char c = value2.charAt(i);
                    if (c == '%') {
                        String hex = value2.substring(i + 1, i + 3);
                        c = (char)Integer.parseInt(hex, 16);
                        i += 2;
                    }
                    b[bi++] = (byte)c;
                }
                v.value = new String(b, 0, bi, MimeUtility.javaCharset(charset));
            }
            catch (NumberFormatException nex) {
                if (decodeParametersStrict) {
                    throw new ParseException(nex.toString());
                }
            }
            catch (UnsupportedEncodingException uex) {
                if (decodeParametersStrict) {
                    throw new ParseException(uex.toString());
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                if (!decodeParametersStrict) break block12;
                throw new ParseException(ex.toString());
            }
        }
        return v;
    }

    static {
        try {
            String s = System.getProperty("mail.mime.encodeparameters");
            encodeParameters = s != null && s.equalsIgnoreCase("true");
            s = System.getProperty("mail.mime.decodeparameters");
            decodeParameters = s != null && s.equalsIgnoreCase("true");
            s = System.getProperty("mail.mime.decodeparameters.strict");
            decodeParametersStrict = s != null && s.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static class ParamEnum
    implements Enumeration {
        private Iterator it;

        ParamEnum(Iterator it) {
            this.it = it;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }

    private static class Value {
        String value;
        String encodedValue;

        private Value() {
        }
    }
}

