\name{quickSort}
\alias{quickSort}

\title{
Quicksort for Partial Orderings
}
\description{
Implements the quicksort algorithm for partial orderings based on pairwise
comparisons.
}
\usage{
quickSort(x, f = greaterThan, random = TRUE)
}
\arguments{
  \item{x}{
A list or vector of items to be sorted.
}
  \item{f}{
A function on two arguments for comparing elements of \code{x}.  Returns
\code{-1} if the first argument is less than the second, \code{1} for
the reverse, and \code{0} if they are equal or incomparable.
}
  \item{random}{
logical - should a random pivot be chosen? (this is recommended)
Otherwise middle element is used.
}
}
\details{
Implements the usual quicksort algorithm, but may return the same
positions for items which are incomparable (or equal).  Does not test
the validity of \code{f} as a partial order.

If \code{x} is a numeric vector with distinct entries, this behaves just
like \code{\link[base]{order}}.
}
\value{
Returns an integer vector giving each element's position in the order
(minimal element(s) is 1, etc).  
}
\references{
\url{http://en.wikipedia.org/wiki/Quicksort}.
}
\author{
Robin Evans
}

\section{Warning}{Output may not be consistent for certain partial
  orderings (using random pivot), see example below.  All results will
  be consistent with a total ordering which is itselft consistent with 
  the true partial ordering.
  
  \code{f} is not checked to see that it returns a legitimate partial
  order, so results may be meaningless if it is not. 
}

\seealso{
\code{\link[base]{order}}.
}
\examples{
set.seed(1)
quickSort(powerSet(1:3), f=subsetOrder)
quickSort(powerSet(1:3), f=subsetOrder)
# slightly different answers, but both correposnding
# to a legitimate total ordering.
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{arith}
\keyword{optimize}
