% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{channel_geom}
\alias{channel_geom}
\title{Channel geometry}
\usage{
channel_geom(y, B, SS)
}
\arguments{
\item{y}{Flow depth [\eqn{L}].}

\item{B}{Channel bottom width [\eqn{L}].}

\item{SS}{Channel sideslope [\eqn{L L^{-1}}]. For a rectangular channel, \code{SS = 0}.}
}
\value{
Named vector:
  \item{A}{Flow area [\eqn{L^2}].}
  \item{P}{Wetted perimeter [\eqn{L}].}
  \item{R}{Hydraulic radius [\eqn{L}].}
  \item{dAdy}{Water surface width [\eqn{L}].}
  \item{dPdy}{First derivative of wetted perimeter w.r.t. flow depth.}
  \item{dRdy}{First derivative of hydraulic radius w.r.t. flow depth.}
  \item{DH}{Hydraulic depth [\eqn{L}].}
  \item{ybar}{Vertical distance from water surface to centroid of flow area [\eqn{L}].}
}
\description{
Compute geometry relations for trapezoidal channels.
}
\details{
Channel geometry relations are routinely calculated in numerical solutions of steady,
  gradually-varied and unsteady flows. This function is used extensively by internal
  procedures and is made accessible to the user for convenience.
}
\examples{
channel_geom(1.71, 100, 0) # rectangular channel
channel_geom(5.79, 6.1, 1.5) # trapezoidal channel with sideslope 3H:2V
}

