% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RiverPoint.R
\name{RiverPoint}
\alias{RiverPoint}
\title{Points on River Charts}
\usage{
RiverPoint(site, river, distance, value, riverlayout, range = NA,
  type = "l", pt.col = "grey40", pt.bg = "black", pt.pch = 20,
  pt.cex = 1, lbl.cex = 0.7, lbl.adj = c(0.5, 2), lbl.ofs = 0.5,
  lbl.col = "black", lbl.srt = 0, lbl.pos = NULL, lbl.shw = FALSE,
  ln.lwd = 1)
}
\arguments{
\item{site}{a vector of site IDs.}

\item{river}{a vector of river names.}

\item{distance}{a vector of distances from sites to the river mouth.}

\item{value}{a vector of values.}

\item{riverlayout}{the output list of \code{RiverLayout} or \code{RiverMap}.}

\item{range}{point value range. A vector of two values indicating lower
limit and upper limit.}

\item{type}{type of plot. See \code{plot} for details. The default value is
"l", which means "lines".}

\item{pt.col}{point or point border colour.}

\item{pt.bg}{point point background(fill) colour when \code{pt.pch=21:25}.}

\item{pt.pch}{point style.}

\item{pt.cex}{point size.}

\item{lbl.cex}{label size.}

\item{lbl.adj}{label adjustment. One or two values in [0,1] for x and y
(optional) adjustment.}

\item{lbl.ofs}{label position offset.}

\item{lbl.col}{label colour.}

\item{lbl.srt}{label angle.}

\item{lbl.pos}{label position. \code{1} for below, \code{2} for left,
\code{3} for above, and \code{4} for right. See \code{par} for details.}

\item{lbl.shw}{show labels (\code{TRUE}) or not (\code{FALSE}).}

\item{ln.lwd}{line width.}
}
\description{
This function plots scatter points or broken lines on the river chart.
}
\examples{
data(Ballinderry)

riverlayout <- RiverLayout(B.river$River,B.river$Length,
                           B.river$Parent,B.river$Position,
                           B.river$Distance, direction = -1)

RiverDraw(riverlayout)

RiverPoint(B.elevation$Site, B.elevation$River, B.elevation$Distance,
           B.elevation$Elevation, riverlayout)

RiverPoint(B.sitenh4n$Site, B.sitenh4n$River, B.sitenh4n$Distance,
           B.sitenh4n$NH4N_Spring, riverlayout, type = "o",
           pt.col = "#5381FFFF", pt.pch = 21, pt.bg = "lightblue")

RiverPoint(B.sitenh4n$Site, B.sitenh4n$River, B.sitenh4n$Distance,
           B.sitenh4n$NH4N_Autumn, riverlayout, type = "o",
           pt.col = "#FF3931FF", pt.pch = 21, pt.bg = "pink",
           lbl.shw = TRUE)
}
\author{
Feng Mao
}
\seealso{
\code{\link{RiverLayout}}, \code{\link{RiverDraw}},
\code{\link{RiverMap}}, \code{\link{par}}.
}
\keyword{hplot}

