% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segsplit.R
\name{splitsegments}
\alias{splitsegments}
\title{Split Segments by Endpoint Proximity}
\usage{
splitsegments(rivers, tolerance = NULL)
}
\arguments{
\item{rivers}{The river network object to use}

\item{tolerance}{The spatial snapping tolerance to use for detecting
intersection.  If a NULL value is used (default), it will default to the
tolerance that was used in river network creation in \link{line2network}.}
}
\value{
A new, updated river network object
}
\description{
Detects cases in which segments should be split to establish
 appropriate topology, and splits them.  Specifically, it looks for segment
 endpoints intersecting (or within a tolerance of) another
 segment.  It then splits the intersected segment at the point where the
 endpoint of the other segment breaks it.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Koyukuk1)
topologydots(rivers=Koyukuk1)
# Segments 7, 8, 13, and 16 need to be split so topologies will work.  
# Since endpoints are not in the same place, they are not detected as 
# being connected.
plot(x=Koyukuk1)

Koyukuk1split <- splitsegments(rivers=Koyukuk1)
topologydots(rivers=Koyukuk1split)
plot(x=Koyukuk1split)
}
\author{
Matt Tyers
}
\seealso{
\link{line2network}
}

