% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kingdoms.R
\name{kingdoms}
\alias{kingdoms}
\alias{kingdom_name}
\alias{kingdom_names}
\title{Get kingdom names from tsn}
\usage{
kingdom_name(tsn, wt = "json", raw = FALSE, ...)

kingdom_names(wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Get kingdom names from tsn
}
\details{
\itemize{
\item kingdom_name: Get kingdom name for a TSN
\item kingdom_names: Get all possible kingdom names
}
}
\examples{
\dontrun{
kingdom_name(202385)
kingdom_name(202385, wt = "xml")
kingdom_names()
}
}
