% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_checklist.R
\name{italic_checklist}
\alias{italic_checklist}
\title{Get the list of species names in the checklist of the lichens of Italy}
\usage{
italic_checklist(
  genus = NULL,
  family = NULL,
  order = NULL,
  class = NULL,
  phylum = NULL
)
}
\arguments{
\item{genus}{Optional. A genus name to filter the checklist.}

\item{family}{Optional. A family name to filter the checklist.}

\item{order}{Optional. An order name to filter the checklist.}

\item{class}{Optional. A class name to filter the checklist.}

\item{phylum}{Optional. A phylum name to filter the checklist.}
}
\value{
A character vector containing all accepted scientific names from the checklist of ITALIC.
}
\description{
Retrieves the complete list of accepted scientific names from the Checklist of
the Lichens of Italy in ITALIC. The function returns all accepted names of species occurring in Italy and in bordering countries
}
\examples{
\dontrun{
# Get the complete checklist
checklist <- italic_checklist()
# Get the checklist of the species of genus Lecanora
check_lecanora <- italic_checklist(genus ="Lecanora")
}

}
\references{
ITALIC - The Information System on Italian Lichens: National Checklist
\url{https://italic.units.it/index.php?procedure=checklist}
}
