% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{as_pc}
\alias{as_pc}
\title{Display a probability as a (numeric and rounded) percentage.}
\usage{
as_pc(prob, n_digits = 2)
}
\arguments{
\item{prob}{A probability (as a scalar or vector of numeric values from 0 to 1).}

\item{n_digits}{Number of decimal places to which percentage is rounded.
Default: \code{n_digits = 2}.}
}
\value{
A percentage (as a numeric value).
}
\description{
\code{as_pc} is a function that displays a probability \code{prob}
as a percentage (rounded to \code{n_digits} decimals).
}
\details{
\code{as_pc} and its complement function \code{\link{as_pb}} allow
toggling the display of numeric values between percentages and probabilities.
}
\examples{
as_pc(.50)                # 50
as_pc(1/3)                # 33.33
as_pc(1/3, n_digits = 0)  # 33
as_pc(as_pb(12.3))        # 12.3

}
\seealso{
\code{\link{is_prob}} verifies a probability;
\code{\link{is_perc}} verifies a percentage;
\code{\link{is_valid_prob_set}} verifies the validity of probability inputs;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{comp_comp_pair}} computes pairs of complements.

Other utility functions: 
\code{\link{as_pb}()},
\code{\link{plot.box}()}

Other display functions: 
\code{\link{as_pb}()}
}
\concept{display functions}
\concept{utility functions}
