% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxSpecialStrata}
\alias{CoxSpecialStrata}
\alias{CoxSpecialStrata.coxph}
\alias{CoxSpecialStrata.cph}
\alias{CoxSpecialStrata.phreg}
\title{Special character for strata in Cox model}
\usage{
CoxSpecialStrata(object)

\method{CoxSpecialStrata}{coxph}(object)

\method{CoxSpecialStrata}{cph}(object)

\method{CoxSpecialStrata}{phreg}(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}
}
\description{
Return the special character used to indicate the strata variables of the Cox model
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")
d$entry <- 0

##
library(survival)
mCoxS <- coxph(Surv(time, event) ~ strata(X1)+strata(X2), data = d)
CoxSpecialStrata(mCoxS)

##
library(rms)
mCoxS <- cph(Surv(time, event) ~ strat(X1)+strat(X2), data = d, y = TRUE)
CoxSpecialStrata(mCoxS)

##
library(mets)
mCoxS <- phreg(Surv(entry, time, event) ~ strat(X1)+strat(X2), data = d)
CoxSpecialStrata(mCoxS)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
