% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.decomposition.R
\name{plot.decomposition}
\alias{plot.decomposition}
\title{Plots a barplot of the contribution percentages in a \code{decomposition} object. Sets custom plot margins and uses the graphical parameters \code{xlim}, \code{horiz}, \code{las} and \code{xlab} which therefore cannot be customized}
\usage{
\method{plot}{decomposition}(x, decreasing = TRUE, horiz = FALSE, ...)
}
\arguments{
\item{x}{Object returned from decomposition function}

\item{decreasing}{Whether to sort contributions decreasing or not}

\item{horiz}{If the barplots should be printed horizontally or vertically}

\item{...}{Graphical parameter passed on to \code{base::barplot()}}
}
\value{
Invisibly returns \code{x} as the function is called for side effects (plotting).
}
\description{
Plots a barplot of the contribution percentages in a \code{decomposition} object. Sets custom plot margins and uses the graphical parameters \code{xlim}, \code{horiz}, \code{las} and \code{xlab} which therefore cannot be customized
}
\examples{
data(housing)
# Linear regression & decompose 
fit.lm <- lm(bmi ~ sex + tenure + place + age,data = housing)
contrib.lm <- contribution(fit.lm, housing$income)

# plot horizontally, in increasing order
plot(contrib.lm, decreasing = FALSE, horiz = TRUE)
}
