% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inat_obs_project.R
\name{get_inat_obs_project}
\alias{get_inat_obs_project}
\title{Download observations or info from a project}
\usage{
get_inat_obs_project(grpid, type = c("observations", "info"), raw = FALSE)
}
\arguments{
\item{grpid}{Name of the group as an iNaturalist slug or group id}

\item{type}{character Either "observations" or "info"  Observations returns all observations, and "info" returns project details similar to what you can find on a project webpage.}

\item{raw}{logical TRUE or FALSE. If TRUE and searching for project info, returns the raw output of parsed JSON for that project. Otherwise just some basic information is returned as a list}
}
\description{
retrieve observations from a particular iNaturalist project. This function can be used to get either observations or information from a project by project name or ID
}
\details{
An iNaturalist slug is usually the project as single string with words separated by hyphens. For instance, the project "State Flowers of the United States" has a slug of "state-flowers-of-the-united-states-eol-collection".  This can be extracted from the URL for the project usually. The state flowers project has the following URL http://www.inaturalist.org/projects/state-flowers-of-the-united-states-eol-collection
}
\examples{
\dontrun{
 get_inat_obs_project(354, type = "observations")
 get_inat_obs_project("crows-in-vermont", type="info",raw=FALSE)
}
}
