% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riem_anova.R
\name{riem_anova}
\alias{riem_anova}
\title{Compute p-values using permutation test}
\usage{
riem_anova(ss, stat_fun = log_wilks_lambda, nperm = 1000)
}
\arguments{
\item{ss}{An object of class \code{CSuperSample}.}

\item{stat_fun}{A function to compute a statistic
on the \code{CSuperSample} object (default: \code{log_wilks_lambda}).}

\item{nperm}{The number of permutations to generate
for estimating the p-value (default: 1000).}
}
\value{
numeric A permutation-based p-value.
}
\description{
Computes a permutation-based p-value for a given super sample.
The statistic used for the permutation test can be specified
via the \code{stat_fun} argument.
}
\details{
The function computes the statistic on the observed data
and compares it to the distribution of statistics computed
on permuted samples. Under the null hypothesis that group labels
are exchangeable, this provides an exact test (subject to Monte Carlo error).

The permutation test:
\enumerate{
\item Computes the test statistic on the observed data
\item Randomly shuffles group assignments while preserving sample sizes
\item Recomputes the test statistic on each permuted dataset
\item Calculates the p-value as the proportion of permuted statistics
that exceed the observed statistic
}

This approach is computationally efficient and does not require
parameter estimation or synthetic data generation.
}
