% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2longdf.R
\name{matrix2longdf}
\alias{matrix2longdf}
\title{Transform a matrix into a long-format data.frame}
\usage{
matrix2longdf(
  mat,
  row.names,
  col.names,
  longdf.colnames = c("row", "column", "value")
)
}
\arguments{
\item{mat}{A matrix}

\item{row.names}{Character, row names to appear in the \code{data.frame}. If
missing, the \code{rownames} of the matrix will be used. If set to
\code{NULL}, or if the matrix \code{rownames} are \code{NULL}, a integer
index vector starting from 1 will be used.}

\item{col.names}{Charater, column names to appear in the \code{data.frame}.
The rule of handling missing or NULL parameters is the same as
\code{row.names} described above.}

\item{longdf.colnames}{Character, column names of the output long data frame}
}
\value{
A \code{data.frame} object with three columns: \code{row},
\code{column} and \code{value}. If the input matrix is of dimesion
\code{MxN}, the returning \code{data.frame} is of the dimension \code{MNx3}.
}
\description{
The function converts a matrix into a long-format, three-column data.frame,
containing row, columna nd value. Such \sQuote{long} data.frames can be
useful in data visualization and modelling.
}
\details{
The function converts a matrix into a three-column, \sQuote{long} format
data.frame containing row names, column names, and values of the matrix.
}
\note{
The length of \code{row.names} and \code{col.names} should be as the
same as the matrix dimension. Otherwise the function raises warnings.
}
\examples{

test.mat <- matrix(1:12, ncol=4, nrow=3, dimnames=list(LETTERS[1:3],
LETTERS[1:4]))
print(test.mat)
print(matrix2longdf(test.mat))
print(matrix2longdf(test.mat, longdf.colnames=c("From", "To", "Time")))

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
