% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allIdentical.R
\name{allIdentical}
\alias{allIdentical}
\title{Testing whether several objects are all identical with each other}
\usage{
allIdentical(...)
}
\arguments{
\item{\dots}{Objects to be tested. Can be given as a list, or simplying
appending names separated by commas, see example.}
}
\value{
Logical, whether all objects are the same
}
\description{
Given several objects, the function tests whether all of them are identical.
}
\examples{

test1 <- test2 <- test3 <- LETTERS[1:3]
allIdentical(test1, test2, test3)
allIdentical(list(test1, test2, test3))

num1 <- num2 <- num3 <- num4 <- sqrt(3)
allIdentical(num1, num2, num3, num4)

}
\seealso{
\code{\link{identical}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
