% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELR.R
\name{ELR}
\alias{ELR}
\title{Expected LR of a pairwise kinship test}
\usage{
ELR(x, true = x, ids = leaves(x), L1, L2 = NULL, rho = NULL)
}
\arguments{
\item{x}{An hypothesised pedigree connecting two individuals.}

\item{true}{The true relationship between the two individuals.}

\item{ids}{A vector containing the names of the two individuals. Note: These
must occur in both \code{x} and \code{true}.}

\item{L1}{The number of alleles at the first locus.}

\item{L2}{The number of alleles at the second locus, or NULL (default).}

\item{rho}{(If \code{L2} is not NULL.) A numeric vector of recombination
fractions. Values outside the interval \eqn{[0, 0.5]} will raise an error.}
}
\value{
A single number, the expected LR.
}
\description{
Calculates the exact likelihood ratio of a pairwise kinship test,
implementing formulas of Egeland & Slooten (2016).
}
\examples{
#############################
# Fig. 2 of Egeland & Slooten
#############################

rhos = seq(0, 0.5, length = 11)

dat = cbind(
  Grand = ELR(linearPed(2), ids = c(1,5), L1 = 10, L2 = 30, rho = rhos),
  Half = ELR(halfSibPed(), ids = c(4,5), L1 = 10, L2 = 30, rho = rhos),
  Uncle = ELR(avuncularPed(), ids = c(3,6), L1 = 10, L2 = 30, rho = rhos))

matplot(rhos, dat, type = "l",  lwd = 2, ylab = "E[LR]", ylim = c(0, 8))
legend("bottomleft", legend = colnames(dat), lty = 1:3, col = 1:3, lwd = 2)



}
\references{
Egeland, T. and Slooten, K. (2016). \emph{The likelihood ratio as a
random variable for linked markers in kinship analysis}. Int J Legal Med.
}
