% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappaIBD.R
\name{kappaIBD}
\alias{kappaIBD}
\alias{kappaIbdX}
\title{IBD (kappa) coefficients}
\usage{
kappaIBD(x, ids = labels(x), inbredAction = 1)

kappaIbdX(x, ids, sparse = NA, verbose = FALSE)
}
\arguments{
\item{x}{A pedigree in the form of a \code{\link[pedtools:ped]{pedtools::ped}} object.}

\item{ids}{A character (or coercible to character) containing ID labels of two
or more pedigree members.}

\item{inbredAction}{An integer telling the program what to do if either of the
\code{ids} individuals are inbred. Possible values are: 0 = do nothing; 1 = print
a warning message (default); 2 = raise an error. In the first two cases
the coefficients are reported as \code{NA}.}

\item{sparse}{A positive integer, indicating the pedigree size limit for using
sparse arrays (as implemented by the
\href{https://CRAN.R-project.org/package=slam}{slam} package) instead of ordinary
arrays.}

\item{verbose}{A logical.}

\item{...}{Further arguments.}
}
\value{
If \code{ids} has length 2: A numeric vector of length 3: \eqn{(\kappa0,
 \kappa1, \kappa2)}.

If \code{ids} has length > 2: A data frame with one row for each pair of
individuals, and 5 columns. The first two columns contain the ID labels, and
columns 3-5 contain the IBD coefficients.

Unless \code{inbredAction = 2}, the coefficients of pairs involving inbred
individuals (inbred \emph{females} in the X version) are reported as NA.
Furthermore, the X chromosomal \eqn{\kappa2} is NA whenever at least one of
the two individuals is male.
}
\description{
Computes the three IBD coefficients summarising the relationship between two
non-inbred individuals. Both autosomal and X chromosomal versions are
implemented.
}
\details{
For non-inbred individuals a and b, their autosomal IBD coefficients
\eqn{(\kappa0, \kappa1, \kappa2)} are defined as follows: \deqn{\kappa_i = P(a
and b share i alleles IBD at a random autosomal locus)}

The autosomal kappa coefficients are computed from the kinship coefficients.
When a and b are both nonfounders, the following formulas are well-known:
\itemize{
\item \eqn{\kappa2 = \phi_MM * \phi_FF + \phi_MF * \phi_FM}
\item \eqn{\kappa1 = 4 * \phi_ab - 2 * \kappa2}
\item \eqn{\kappa0 = 1 - \kappa1 - \kappa2}
}

Here \eqn{\phi_MM} denotes the kinship coefficient between the mothers of a
and b, and so on. If either a or b is a founder, then \eqn{\kappa2 = 0}, while
the other two formulas remain as above.

The X chromosomal IBD coefficients are defined as in the autosomal case, with
the exception that \eqn{\kappa2} is undefined when at least one of the two
individuals is male. Hence the computation is greatly simplified when males
are involved. Denoting the standard kinship coefficient by \eqn{\phi}, the
formulas are:
\itemize{
\item Both male: \eqn{(\kappa0, \kappa1, \kappa2) = (1-\phi, \phi, NA)}
\item One male, one female: \eqn{(\kappa0, \kappa1, \kappa2) = (1-2*\phi, 2*\phi,
NA)}
\item Two females: As in the autosomal case.
}
}
\examples{
# Siblings
x = nuclearPed(2)
k = kappaIBD(x, 3:4)
stopifnot(identical(k, c(.25, .5, .25)))

# Quad half first cousins
x = quadHalfFirstCousins()
k = kappaIBD(x, leaves(x))
stopifnot(identical(k, c(17/32, 14/32, 1/32)))

# Paternal half brothers with 100\% inbred father
# Genetically indistinguishable from an (outbred) father-son relationship
x = halfSibPed()
founderInbreeding(x, 1) = 1

k = kappaIBD(x, 4:5)
stopifnot(identical(k, c(0, 1, 0)))

}
\seealso{
\code{\link[=kinship]{kinship()}}, \code{\link[=condensedIdentity]{condensedIdentity()}}
}
