% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_units_1.R
\name{move_units_1}
\alias{move_units_1}
\title{move_units_1}
\usage{
move_units_1(snp.object, partition, threshold = 1e-05,
  frac.clust.searched = 0.3, min.clust.size = 20, n.cores = 1)
}
\arguments{
\item{snp.object}{A snp.object containing the processed SNP data.}

\item{partition}{An integer vector indicating an initial partition of the isolates.}

\item{threshold}{The increase in marginal log likelihood required to accept a move.}

\item{frac.clust.searched}{The percentage of a large cluster that will be moved.}

\item{min.clust.size}{All isolates in clusters less than or equal to min.clus.size will be searched.}

\item{n.cores}{The number of cores to use.}
}
\value{
The best partition after moving units from one cluster to another as well as
a boolean value indicating whether a move increased the marginal likelihood.
}
\description{
Peform an iteration of the first move in the algorithm. That is move units from one cluster to
another to improve the marginal likelihood
}
