% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_cols}
\alias{hot_cols}
\title{Handsontable widget}
\usage{
hot_cols(hot, columns = NULL, colWidths = NULL, columnSorting = NULL,
  manualColumnMove = NULL, manualColumnResize = NULL,
  fixedColumnsLeft = NULL, ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{columns}{a list of column settings}

\item{colWidths}{a scalar or numeric vector of column widths}

\item{columnSorting}{logical enabling row sorting. Sorting only alters the
table presentation and the original dataset row order is maintained.}

\item{manualColumnMove}{logical enabling column drag-and-drop reordering}

\item{manualColumnResize}{logical enabline column width resizing}

\item{fixedColumnsLeft}{a numeric vector indicating which columns should be
frozen on the left}

\item{...}{passed to hot_col}
}
\description{
Configure multiple columns.
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF) \%>\%
  hot_cols(columnSorting = TRUE)
}

