% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_download.R
\name{tile_download}
\alias{tile_download}
\title{downloads tiles based on the data frame obtained using
the orto_request() and DEM_request() functions}
\usage{
tile_download(
  df_req,
  outdir = ".",
  unzip = TRUE,
  check_SHA = FALSE,
  print_iter = TRUE,
  ...
)
}
\arguments{
\item{df_req}{a data frame obtained using the \code{\link[=orto_request]{orto_request()}} and
\code{\link[=DEM_request]{DEM_request()}} functions}

\item{outdir}{(optional) name of the output directory;
by default, files are saved in the working directory}

\item{unzip}{TRUE (default) or FALSE, when TRUE the downloaded archive will
be extracted and removed; only suitable for certain elevation data}

\item{check_SHA}{check the integrity of downloaded files
(logical, FALSE default)}

\item{print_iter}{print the current iteration of all
(logical, TRUE default)}

\item{...}{additional argument for \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
georeferenced tiles with properties (resolution, year, etc.)
as specified in the input data frame
}
\description{
downloads tiles based on the data frame obtained using
the orto_request() and DEM_request() functions
}
\examples{
\dontrun{
library(sf)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)

req_df = orto_request(polygon)
tile_download(req_df[1, ]) # download the first image only

req_df = DEM_request(polygon)
tile_download(req_df[1, ]) # download the first DEM only
}
}
