% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{MiniBatchKMeans}
\alias{MiniBatchKMeans}
\title{Performs clustering according to the mini-batch k-means algorithm}
\description{
This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.MiniBatchKMeans.html#sklearn.cluster.MiniBatchKMeans}{sklearn.cluster.MiniBatchKMeans}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- MiniBatchKMeans$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{MiniBatchKMeans}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MiniBatchKMeans-new}{\code{MiniBatchKMeans$new()}}
\item \href{#method-MiniBatchKMeans-clone}{\code{MiniBatchKMeans$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiniBatchKMeans-new"></a>}}
\if{latex}{\out{\hypertarget{method-MiniBatchKMeans-new}{}}}
\subsection{Method \code{new()}}{
The \link{MiniBatchKMeans} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiniBatchKMeans$new(
  n_clusters = 2L,
  init = c("k-means++", "random"),
  n_init = 10L,
  max_iter = 300L,
  tol = 1e-04,
  verbose = 0L,
  random_state = NULL,
  batch_size = 1024L,
  compute_labels = TRUE,
  max_no_improvement = 10L,
  init_size = NULL,
  reassignment_ratio = 0.01
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_clusters}}{An integer value specifying the number of clusters to
form as well as the number of centroids to generate. Defaults to \code{2L}.}

\item{\code{init}}{Either a string or a numeric matrix of shape
\eqn{\mathrm{n_clusters} \times \mathrm{n_features}} specifying the
method for initialization. If a string, choices are:
\itemize{
\item \code{"k-means++"}: selects initial cluster centroids using sampling based
on an empirical probability distribution of the points’ contribution to
the overall inertia. This technique speeds up convergence, and is
theoretically proven to be \eqn{\mathcal{O}(\log(k))}-optimal. See the
description of \code{n_init} for more details;
\item \code{"random"}: chooses \code{n_clusters} observations (rows) at random from
data for the initial centroids.
Defaults to \code{"k-means++"}.
}}

\item{\code{n_init}}{An integer value specifying the number of times the k-means
algorithm will be run with different centroid seeds. The final results
will be the best output of \code{n_init} consecutive runs in terms of
inertia. Defaults to \code{10L}.}

\item{\code{max_iter}}{An integer value specifying the maximum number of
iterations of the k-means algorithm for a single run. Defaults to
\code{300L}.}

\item{\code{tol}}{A numeric value specifying the relative tolerance with regards
to Frobenius norm of the difference in the cluster centers of two
consecutive iterations to declare convergence. Defaults to \code{1e-4}.}

\item{\code{verbose}}{An integer value specifying the level of verbosity.
Defaults to \code{0L} which is equivalent to no verbose.}

\item{\code{random_state}}{An integer value specifying the initial seed of the
random number generator. Defaults to \code{NULL} which uses the current
timestamp.}

\item{\code{batch_size}}{An integer value specifying the size of the
mini-batches. For faster computations, you can set the \code{batch_size}
greater than 256 * number of cores to enable parallelism on all cores.
Defaults to \code{1024L}.}

\item{\code{compute_labels}}{A boolean value specifying whether to compute label
assignment and inertia for the complete dataset once the minibatch
optimization has converged in fit. Defaults to \code{TRUE}.}

\item{\code{max_no_improvement}}{An integer value specifying how many
consecutive mini batches that does not yield an improvement on the
smoothed inertia should be used to call off the algorithm. To disable
convergence detection based on inertia, set \code{max_no_improvement} to
\code{NULL}. Defaults to \code{10L}.}

\item{\code{init_size}}{An integer value specifying the number of samples to
randomly sample for speeding up the initialization (sometimes at the
expense of accuracy): the only algorithm is initialized by running a
batch \link{KMeans} on a random subset of the data. This needs to be larger
than \code{n_clusters}. If \code{NULL}, the heuristic is \code{init_size = 3 * batch_size} if \code{3 * batch_size < n_clusters}, else \code{init_size = 3 * n_clusters}. Defaults to \code{NULL}.}

\item{\code{reassignment_ratio}}{A numeric value specifying the fraction of the
maximum number of counts for a center to be reassigned. A higher value
means that low count centers are more easily reassigned, which means
that the model will take longer to converge, but should converge in a
better clustering. However, too high a value may cause convergence
issues, especially with a small batch size. Defaults to \code{0.01}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{MiniBatchKMeans}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MiniBatchKMeans-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MiniBatchKMeans-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MiniBatchKMeans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
