% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonProperties.R
\name{page_element_property}
\alias{page_element_property}
\title{Common Property: Page Element Property}
\usage{
page_element_property(page_object_id = NULL, width_magnitude = NULL,
  height_magnitude = NULL, scale_x = NULL, scale_y = NULL,
  shear_x = NULL, shear_y = NULL, translate_x = NULL,
  translate_y = NULL, width_unit = "PT", height_unit = "PT",
  transform_unit = "PT")
}
\arguments{
\item{page_object_id}{A character vector that contains the page id of the slide}

\item{width_magnitude}{(Optional) A numeric vector that contains the width of the component}

\item{height_magnitude}{(Optional) A numeric vector that contains the height of the component}

\item{scale_x}{(Optional) A numeric vector that tells how the object is to be sized}

\item{scale_y}{(Optional) A numeric vector that tells how the object is to be sized}

\item{shear_x}{(Optional) A numeric vector that tells how the object is to be sheared}

\item{shear_y}{(Optional) A numeric vector that tells how the object is to be sheared}

\item{translate_x}{(Optional) A numeric vector that tells how the object is to be located}

\item{translate_y}{(Optional) A numeric vector that tells how the object is to be located}

\item{width_unit}{(Optional) A string vector that tells the measurement unit to use to locate the
elements on the slide for the width element}

\item{height_unit}{(Optional) A string vector that tells the measurement unit to use to locate the
elements on the slide for the height element}

\item{transform_unit}{(Optional) A string vector that tells the measurement unit to use to locate the
elements on the slide for the transform element}
}
\value{
A PageElementProperty Object
}
\description{
This property is repeated in various of the request. Hence, to reduce the number of
times this would appear in the code base, a function is created to handle the creation of this
list.
}
\examples{
\dontrun{
library(googleslides)

# There is only one compulsory field which is pageObjectId is the
# 'slide id' of the slide being referenced to
pageElementProperty <- page_element_property("12345")
}
}
