% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfMIF.R
\name{rfMIF}
\alias{rfMIF}
\alias{rfMIF.default}
\alias{rfMIF.formula}
\title{Mutual Information-based Filter for Regression}
\usage{
\method{rfMIF}{default}(x, y, k = 5, alpha = 0.05, ...)

\method{rfMIF}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{k}{an integer with the number of nearest neighbors to be used (default: 5).}

\item{alpha}{a double in [0,1] with the \emph{threshold} used by rfMIF (default: 0.05).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata}, \link{summary.rfdata} and \link{plot.rfdata} methods.
}
\description{
Application of the rfMIF noise filtering method in a regression dataset.
}
\details{
The \code{rfMIF} filter harnesses mutual information to enhance the prototypes within the training set. 
First, it identifies the \emph{k}-nearest neighbors for each data point. 
Subsequently, mutual information values are calculated and standardized between 0 and 1. 
\code{rfMIF} then compares the mutual information of each data point to its \emph{k}-nearest neighbors. 
If the discrepancy surpasses a threshold (\code{alpha}), the sample is considered noisy.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- rfMIF(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- rfMIF(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
A. Guillen, L. Herrera, G. Rubio, H. Pomares, A. Lendasse, I. Rojas, 
\strong{New method for instance or prototype selection using mutual information in time series prediction.},
\emph{Neurocomputing}, 73:2030-2038, 2010.
\doi{https://doi.org/10.1016/j.neucom.2009.11.031}.

M. Stojanović, M. Božić, M. Stanković, Z. Stajić,
\strong{A methodology for training set instance selection using mutual information in time series prediction.}
\emph{Neurocomputing}, 141:236-245, 2014.
\doi{https://doi.org/10.1016/j.neucom.2014.03.006}.
}
\seealso{
\code{\link{regENN}}, \code{\link{regAENN}}, \code{\link{regCNN}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
