% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_get.r
\name{occ_get}
\alias{occ_get}
\alias{occ_get_verbatim}
\title{Get data for GBIF occurrences by occurrence key}
\usage{
occ_get(
  key,
  fields = "minimal",
  curlopts = list(),
  return = NULL,
  verbatim = NULL
)

occ_get_verbatim(key, fields = "minimal", curlopts = list())
}
\arguments{
\item{key}{(numeric/integer) one or more occurrence keys. required}

\item{fields}{(character) Default ("minimal") will return just taxon name,
key, latitude, and longitude. 'all' returns all fields. Or specify each
field you want returned by name, e.g. fields = c('name',
'decimalLatitude','altitude').}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}

\item{return}{Defunct. All components are returned now; index to the
one(s) you want}

\item{verbatim}{Defunct. verbatim records can now be retrieved using
\code{occ_get_verbatim()}}
}
\value{
For \code{occ_get} a list of lists. For \code{occ_get_verbatim} a data.frame
}
\description{
Get data for GBIF occurrences by occurrence key
}
\examples{
\dontrun{
occ_get(key=855998194)

# many occurrences
occ_get(key=c(101010, 240713150, 855998194))

# Verbatim data
occ_get_verbatim(key=855998194)
occ_get_verbatim(key=855998194, fields='all')
occ_get_verbatim(key=855998194,
 fields=c('scientificName', 'lastCrawled', 'county'))
occ_get_verbatim(key=c(855998194, 620594291))
occ_get_verbatim(key=c(855998194, 620594291), fields='all')
occ_get_verbatim(key=c(855998194, 620594291),
   fields=c('scientificName', 'decimalLatitude', 'basisOfRecord'))

# curl options, pass in a named list
occ_get(key=855998194, curlopts = list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/occurrence#occurrence}
}
