% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/occ_download.R
\name{occ_download}
\alias{occ_download}
\title{Spin up a download request for GBIF occurrence data.}
\usage{
occ_download(..., type = "and", user = getOption("gbif_user"),
  pwd = getOption("gbif_pwd"), email = "myrmecocystus@gmail.com",
  callopts = list())
}
\arguments{
\item{...}{One or more of query arguments to kick of a download job. See Details.}

\item{type}{(charcter) One of equals (=), and (&), or (|), lessThan (<), lessThanOrEquals (<=),
greaterThan (>), greaterThanOrEquals (>=), in, within, not (!), like}

\item{user}{(character) User name within GBIF's website. Required.}

\item{pwd}{(character) User password within GBIF's website. Required.}

\item{email}{(character) Email address to recieve download notice done email. Requried.}

\item{callopts}{Further named arguments passed on to \code{\link[httr]{POST}}}
}
\description{
Spin up a download request for GBIF occurrence data.
}
\details{
Argument passed have to be passed as character (e.g., 'country = US'), with a space
between key ('country'), operator ('='), and value ('US'). See the \code{type} parameter for
possible options for the operator.  This character string is parsed internally.

Acceptable arguments to \code{...} are:
\itemize{
 \item taxonKey = 'TAXON_KEY'
 \item scientificName = 'SCIENTIFIC_NAME'
 \item country = 'COUNTRY'
 \item publishingCountry = 'PUBLISHING_COUNTRY'
 \item hasCoordinate = 'HAS_COORDINATE'
 \item hasGeospatialIssue = 'HAS_GEOSPATIAL_ISSUE'
 \item typeStatus = 'TYPE_STATUS'
 \item recordNumber = 'RECORD_NUMBER'
 \item lastInterpreted = 'LAST_INTERPRETED'
 \item continent = 'CONTINENT'
 \item geometry = 'GEOMETRY'
 \item basisOfRecord = 'BASIS_OF_RECORD'
 \item datasetKey = 'DATASET_KEY'
 \item eventDate = 'EVENT_DATE'
 \item catalogNumber = 'CATALOG_NUMBER'
 \item year = 'YEAR'
 \item month = 'MONTH'
 \item decimalLatitude = 'DECIMAL_LATITUDE'
 \item decimalLongitude = 'DECIMAL_LONGITUDE'
 \item elevation = 'ELEVATION'
 \item depth = 'DEPTH'
 \item institutionCode = 'INSTITUTION_CODE'
 \item collectionCode = 'COLLECTION_CODE'
 \item issue = 'ISSUE'
 \item mediatype = 'MEDIA_TYPE'
 \item recordedBy = 'RECORDED_BY'
}
}
\examples{
\dontrun{
# occ_download("basisOfRecord = LITERATURE")
# occ_download('taxonKey = 3119195')
# occ_download('decimalLatitude > 50')
# occ_download('elevation >= 9000')
# occ_download('decimalLatitude >= 65')
# occ_download("country = US")
# occ_download("institutionCode = TLMF")
# occ_download("catalogNumber = Bird.27847588")

# res <- occ_download('taxonKey = 7264332', 'hasCoordinate = TRUE')

# pass output directly, or later, to occ_download_meta for more information
# occ_download('decimalLatitude > 75') \%>\% occ_download_meta

# Multiple queries
# occ_download('decimalLatitude >= 65', 'decimalLatitude <= -65', type="or")
# gg <- occ_download('depth = 80', 'taxonKey = 2343454', type="or")
}
}
\references{
See the API docs \url{http://www.gbif.org/developer/occurrence#download} for
more info, and the predicates docs \url{http://www.gbif.org/developer/occurrence#predicates}.
}

