% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-statistics.R
\name{var.pop}
\alias{var.pop}
\title{Population variance}
\usage{
var.pop(x, na.rm = FALSE)
}
\arguments{
\item{x}{a ml.data.frame field.}

\item{na.rm}{not used currently}
}
\value{
The population variance
}
\description{
Returns the population variance of of a \link{ml.data.frame} field.
}
\details{
The function returns a empty value if the number of rows of the ml.data.frame
that x belongs to is less than 2.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(locConn, collection = "iris")
 # population variance
 var.pop(mlIris$Sepal.Length)
}
}

