% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{ml.load.sample.data}
\alias{ml.load.sample.data}
\title{Load sample data set into MarkLogic server}
\usage{
ml.load.sample.data(conn, dataSet = "baskets", name = "")
}
\arguments{
\item{conn}{A \link{ml.conn-class} with a connection to a MarkLoic server}

\item{dataSet}{Which dataset to upload, "baskets"}

\item{name}{The name of the object. The data will be added to a collection with that name. If not provided the dataSet name is used.}
}
\value{
A \link{ml.data.frame} object pointing to the uploaded dataset.
}
\description{
The function uploads a sample data set to MarkLogic Server and returns a ml.data.frame object.
Provided data sets are:
\itemize{
 \item "baskets" - sample order documents that can be used with the \link{ml.arules} function.
 }
To remove the sample use the \link{rm.ml.data.frame} on the returned ml.data.frame object.
}
\examples{
\dontrun{
 locConn <- ml.connect()
 mlBaskets <- ml.load.sample.data(locConn, "baskets")
}
}

