% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_db.R
\name{default_db}
\alias{default_db}
\title{Connect to the rfishbase database}
\usage{
default_db(dbdir = db_dir(), driver = Sys.getenv("DB_DRIVER", "RSQLite"))
}
\arguments{
\item{dbdir}{Path to the database.}

\item{driver}{Default driver, one of "duckdb", "MonetDBLite", "RSQLite".
`rfishbase` will select the first one of those it finds available if a
driver is not set. This fallback can be overwritten either by explicit
argument or by setting the environmental variable `rfishbase_DRIVER`.}
}
\value{
Returns a `src_dbi` connection to the default duckdb database
}
\description{
Connect to the rfishbase database
}
\details{
This function provides a default database connection for
`rfishbase`. Note that you can use `rfishbase` with any DBI-compatible database
connection  by passing the connection object directly to `rfishbase`
functions using the `db` argument. `default_db()` exists only to provide
reasonable automatic defaults based on what is available on your system.

`duckdb` or `MonetDBLite` will give the best performance, and regular users
`rfishbase` will work with the built-in `RSQlite`, and with other database connections
such as Postgres or MariaDB, but queries (filtering joins) will be much slower
on these non-columnar databases.

For performance reasons, this function will also cache and restore the
existing database connection, making repeated calls to `default_db()` much
faster and more failsafe than repeated calls to [DBI::dbConnect]
}
\examples{
\donttest{
## OPTIONAL: you can first set an alternative home location,
## such as a temporary directory:
Sys.setenv(FISHBASE_HOME=tempdir())

## Connect to the database:
db <- default_db()

}
}
