% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_names.R
\name{common_names}
\alias{common_names}
\alias{commonnames}
\title{commonnames}
\usage{
common_names(species_list, limit = 1000, server = getOption("FISHBASE_API",
  FISHBASE_API), Language = NULL, fields = c("ComName", "Language",
  "C_Code", "SpecCode"))
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, the table will be loaded up to the limit. This makes it possible to load an entire table without knowledge of the species in the table, thus avoiding uneccesary API calls.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{Language}{a string specifying the language for the common name, e.g. "English"}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned. This option can be used to limit the amount
of data transfered over the network if only certain columns are needed.}
}
\value{
a data.frame of common names by species queried. If multiple species are queried,
The resulting data.frames are concatenated.
}
\description{
Return a table of common names
}
\details{
Note that there are many common names for a given sci name, so sci_to_common doesn't make sense
}
\examples{
\dontrun{
commonnames(c("Labroides bicolor",  "Bolbometopon muricatum"))

# subset by English language names
fish <- commonnames("Bolbometopon muricatum")
library(dplyr)
fish \%>\% filter(Language=="English") 
}
}

