% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/common_names.R
\name{common_to_sci}
\alias{common_to_sci}
\title{common_to_sci}
\usage{
common_to_sci(x, Language = NULL, limit = 1000,
  server = getOption("FISHBASE_API", FISHBASE_API))
}
\arguments{
\item{x}{a common name or list of common names}

\item{Language}{a string specifying the language for the common name, e.g. "English"}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}
}
\value{
a character vector of scientific names
}
\description{
Return a list of scientific names corresponding to given the common name(s).
}
\details{
If more than one scientific name matches the common name (e.g. "trout"), the function
will simply return a list of all matching scientific names.  If given more than one common name,
the resulting strings of matching scientific names are simply concatenated.

Setting the language used explicitly will decrease the data transferred and speed up the function.
The limit default is quite high in this call, as it corresponds to the number of common names that
match a given species, including different languages and countries.
}
\examples{
\donttest{
common_to_sci(c("Bicolor cleaner wrasse", "humphead parrotfish"), Language="English")
common_to_sci("trout")
common_to_sci(c("trout", "Coho Salmon"))
}
}
\seealso{
\code{\link{commonnames}}, \code{\link{species_list}}, \code{\link{synonyms}}
}

