% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{at_least}
\alias{at_most}
\alias{between}
\alias{counts}
\alias{n}
\alias{n_times}
\title{Counts}
\usage{
n_times(x, n, type = c("greedy", "lazy", "possessive"))

between(x, low, high, type = c("greedy", "lazy", "possessive"))

at_least(x, n, type = c("greedy", "lazy", "possessive"))

at_most(x, n, type = c("greedy", "lazy", "possessive"))
}
\arguments{
\item{x}{A regex pattern.}

\item{n}{An integer number}

\item{type}{the type of match to perform.

There are three match types
\enumerate{
  \item \code{greedy}: match the longest string.  This is the default matching type.
  \item \code{lazy}: match the shortest string.  This matches the shortest string from the same anchor point, not necessarily the shortest global string.
  \item \code{possessive}: match and don't allow backtracking
}}

\item{low}{An integer number for the lower limit.}

\item{high}{An integer number for the upper limit.}
}
\description{
Functions to restrict a regex to a specific number
}
\section{Functions}{
\itemize{
\item \code{n_times}: \code{x} must occur exactly \code{n} times.

\item \code{between}: \code{x} must occur between \code{low} and \code{high} times.

\item \code{at_least}: \code{x} must occur at least \code{n} times.

\item \code{at_most}: \code{x} must occur at most \code{n} times.
}}
\seealso{
Other rex: \code{\link{.}}, \code{\link{capture}},
  \code{\link{capture_group}}; \code{\link{:}},
  \code{\link{any_of}}, \code{\link{character_class}},
  \code{\link{except}}, \code{\link{except_any_of}},
  \code{\link{except_some_of}},
  \code{\link{exclude_range}}, \code{\link{none_of}},
  \code{\link{one_of}}, \code{\link{range}},
  \code{\link{some_of}}; \code{\link{\%if_next_is\%}},
  \code{\link{\%if_next_isnt\%}},
  \code{\link{\%if_prev_is\%}},
  \code{\link{\%if_prev_isnt\%}},
  \code{\link{lookarounds}}; \code{\link{\%or\%}},
  \code{\link{or}}; \code{\link{group}};
  \code{\link{maybe}}, \code{\link{one_or_more}},
  \code{\link{wildcards}}, \code{\link{zero_or_more}},
  \code{\link{zero_or_one}}; \code{\link{not}};
  \code{\link{rex}}, \code{\link{rex_}};
  \code{\link{shortcuts}}
}

